/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.impl;

import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.After;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.definition.impl.ExperimentalFeatureDefRegistryImpl;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.impl.AbstractExperimentalFeaturesStorage;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

public abstract class AbstractExperimentalFeaturesStorageTest<STORAGE extends AbstractExperimentalFeaturesStorage> {
    protected static final String GLOBAL_FEATURE_1 = "globalFeature_1";
    protected static final String GLOBAL_FEATURE_2 = "globalFeature_2";
    protected static final String GLOBAL_FEATURE_3 = "globalFeature_3";
    protected static final String FEATURE_1 = "feature_1";
    protected static final String FEATURE_2 = "feature_2";
    protected static final String FEATURE_3 = "feature_3";
    protected static final String USER_NAME = "my-user";
    protected static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    protected SessionInfo sessionInfo;
    @Mock
    protected SpacesAPI spaces;
    @Mock
    protected IOService ioService;
    @Mock
    protected ExperimentalFeatureDefRegistryImpl defRegistry;
    protected FileSystem fileSystem;
    protected STORAGE storage;

    @Before
    public void init() throws IOException {
        MappingContextSingleton.get();
        fileSystemTestingUtils.setup();
        this.sessionInfo = new SessionInfoMock(USER_NAME);
        this.fileSystem = fileSystemTestingUtils.getFileSystem();
        this.ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).endBatch();
        ((IOService)Mockito.doReturn((Object)this.fileSystem).when((Object)this.ioService)).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
        this.defRegistry = new ExperimentalFeatureDefRegistryImpl();
        this.defRegistry.register(new ExperimentalFeatureDefinition(GLOBAL_FEATURE_1, true, "", GLOBAL_FEATURE_1, GLOBAL_FEATURE_1));
        this.defRegistry.register(new ExperimentalFeatureDefinition(GLOBAL_FEATURE_2, true, "", GLOBAL_FEATURE_2, GLOBAL_FEATURE_2));
        this.defRegistry.register(new ExperimentalFeatureDefinition(GLOBAL_FEATURE_3, true, "", GLOBAL_FEATURE_3, GLOBAL_FEATURE_3));
        this.defRegistry.register(new ExperimentalFeatureDefinition(FEATURE_1, false, "", FEATURE_1, FEATURE_1));
        this.defRegistry.register(new ExperimentalFeatureDefinition(FEATURE_2, false, "", FEATURE_2, FEATURE_2));
        this.defRegistry.register(new ExperimentalFeatureDefinition(FEATURE_3, false, "", FEATURE_3, FEATURE_3));
        this.storage = this.getStorageInstance();
    }

    abstract STORAGE getStorageInstance();

    protected void verifyLoadedFeatures(List<ExperimentalFeatureImpl> features, ExperimentalFeature feature1, ExperimentalFeature feature2, ExperimentalFeature feature3) {
        features.sort(Comparator.comparing(ExperimentalFeatureImpl::getFeatureId));
        ((ListAssert)Assertions.assertThat(features).isNotNull()).hasSize(3);
        ((AbstractObjectAssert)Assertions.assertThat((Object)features.get(0)).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)feature1.getFeatureId()).hasFieldOrPropertyWithValue("enabled", (Object)feature1.isEnabled());
        ((AbstractObjectAssert)Assertions.assertThat((Object)features.get(1)).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)feature2.getFeatureId()).hasFieldOrPropertyWithValue("enabled", (Object)feature2.isEnabled());
        ((AbstractObjectAssert)Assertions.assertThat((Object)features.get(2)).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)feature3.getFeatureId()).hasFieldOrPropertyWithValue("enabled", (Object)feature3.isEnabled());
    }

    @After
    public void clean() {
        fileSystemTestingUtils.cleanup();
        try {
            this.ioService.delete(this.fileSystem.getPath(this.storage.getStoragePath(), new String[0]), new DeleteOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

