/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.service.BackendExperimentalFeaturesRegistryServiceImpl;
import org.uberfire.experimental.service.backend.ExperimentalFeaturesSession;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.impl.ExperimentalFeatureDefRegistryImpl;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.experimental.service.registry.ExperimentalFeaturesRegistry;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.ExperimentalFeaturesStorage;
import org.uberfire.experimental.service.storage.impl.ExperimentalFeaturesStorageImpl;
import org.uberfire.experimental.service.util.TestUtils;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class BackendExperimentalFeaturesRegistryServiceImplTest {
    protected static final String UNEXISTING_FEATURE = "unexisting featureID";
    protected static final String USER_NAME = "my-user";
    @Mock
    private ExperimentalFeaturesStorageImpl storage;
    private BackendExperimentalFeaturesRegistryServiceImpl service;
    protected SessionInfo sessionInfo;
    protected ExperimentalFeatureDefRegistryImpl defRegistry;

    @Before
    public void init() {
        this.sessionInfo = new SessionInfoMock(USER_NAME);
        this.defRegistry = TestUtils.getRegistry();
    }

    @Test
    public void testLoadRegistryWithExistingData() {
        this.init(true);
        Assert.assertTrue((boolean)this.service.isFeatureEnabled("globalFeature_1"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("globalFeature_2"));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled("globalFeature_3"));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled("feature_1"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("feature_2"));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled("feature_3"));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(UNEXISTING_FEATURE));
    }

    @Test
    public void testLoadRegistryWithExistingDataExperimentalDisabled() {
        this.init(false);
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("globalFeature_1"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("globalFeature_2"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("globalFeature_3"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("feature_1"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("feature_2"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("feature_3"));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(UNEXISTING_FEATURE));
    }

    @Test
    public void testLoadRegistryWithoutExistingDataExperimentalDisabled() {
        this.init(false);
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("globalFeature_1"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("globalFeature_2"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("globalFeature_3"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("feature_1"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("feature_2"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("feature_3"));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(UNEXISTING_FEATURE));
    }

    @Test
    public void testStoreUserLevelFeature() {
        this.testStoreFeature("feature_1", false);
    }

    @Test
    public void testStoreGlobalFeature() {
        this.testStoreFeature("globalFeature_1", false);
    }

    @Test
    public void testStoreWrongFeature() {
        this.init(true);
        Assertions.assertThatThrownBy(() -> this.service.save(new EditableExperimentalFeature(UNEXISTING_FEATURE, true))).hasMessage("Cannot find ExperimentalFeature 'unexisting featureID'").isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testStoreFeatureExperimentalDisabled() {
        this.init(false);
        this.testStoreFeatureExperimentalFeatureDisabled("globalFeature_1");
        this.testStoreFeatureExperimentalFeatureDisabled("feature_1");
        this.testStoreFeatureExperimentalFeatureDisabled(UNEXISTING_FEATURE);
        this.testStoreFeatureExperimentalFeatureDisabled(UNEXISTING_FEATURE);
    }

    private void testStoreFeatureExperimentalFeatureDisabled(String featureId) {
        Assertions.assertThatThrownBy(() -> this.service.save(new EditableExperimentalFeature(featureId, true))).hasMessage("Impossible edit feature '" + featureId + "': Experimental Framework is disabled").isInstanceOf(IllegalStateException.class);
        ((ExperimentalFeaturesStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.never())).store((ExperimentalFeatureImpl)Matchers.any());
    }

    private void testStoreFeature(String featureId, boolean newValue) {
        this.init(true);
        this.service.save(new EditableExperimentalFeature(featureId, newValue));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ExperimentalFeatureImpl.class);
        ((ExperimentalFeaturesStorageImpl)Mockito.verify((Object)this.storage)).store((ExperimentalFeatureImpl)captor.capture());
        ExperimentalFeatureImpl feature = (ExperimentalFeatureImpl)captor.getValue();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)feature).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)featureId)).hasFieldOrPropertyWithValue("enabled", (Object)newValue);
    }

    private void init(Boolean enableExperimental) {
        System.setProperty("appformer.experimental.features", enableExperimental.toString());
        List<String> disableFeatures = Arrays.asList("globalFeature_2", "feature_2");
        Mockito.when((Object)this.storage.getFeatures()).thenAnswer(invocationOnMock -> this.defRegistry.getAllFeatures().stream().map(featureDefinition -> new ExperimentalFeatureImpl(featureDefinition.getId(), !disableFeatures.contains(featureDefinition.getId()))).collect(Collectors.toList()));
        this.service = new BackendExperimentalFeaturesRegistryServiceImpl((ExperimentalFeatureDefRegistry)this.defRegistry, (ExperimentalFeaturesStorage)this.storage);
        ExperimentalFeaturesSession session = this.service.getExperimentalFeaturesSession();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)session).isNotNull()).hasFieldOrPropertyWithValue("experimentalFeaturesEnabled", (Object)enableExperimental)).hasFieldOrProperty("registry");
        ExperimentalFeaturesRegistry registry = session.getFeaturesRegistry();
        ((IterableAssert)Assertions.assertThat((Iterable)registry.getAllFeatures()).isNotNull()).hasSize(6);
    }

    @After
    public void clear() {
        System.clearProperty("appformer.experimental.features");
    }
}

