/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.migration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.service.storage.migration.StorageMigration;
import org.uberfire.experimental.service.storage.migration.impl.StorageMigrationServiceImpl;
import org.uberfire.java.nio.file.FileSystem;

@RunWith(value=MockitoJUnitRunner.class)
public class StorageMigrationServiceImplTest {
    @Mock
    private StorageMigration migration1;
    @Mock
    private StorageMigration migration2;
    @Mock
    private StorageMigration migration3;
    @Mock
    private FileSystem fileSystem;
    private List<StorageMigration> migrationList = new ArrayList<StorageMigration>();
    private StorageMigrationServiceImpl migrationService;

    @Before
    public void init() {
        Mockito.when((Object)this.migration1.getTargetVersion()).thenReturn((Object)1);
        Mockito.when((Object)this.migration2.getTargetVersion()).thenReturn((Object)2);
        Mockito.when((Object)this.migration3.getTargetVersion()).thenReturn((Object)3);
        Instance migrations = (Instance)Mockito.mock(Instance.class);
        this.migrationList.add(this.migration3);
        this.migrationList.add(this.migration1);
        this.migrationList.add(this.migration2);
        Mockito.when((Object)migrations.iterator()).thenReturn(this.migrationList.iterator());
        this.migrationService = new StorageMigrationServiceImpl(migrations);
    }

    @Test
    public void testMigrateV1() {
        this.testMigrate(1);
    }

    @Test
    public void testMigrateV2() {
        this.testMigrate(2);
    }

    @Test
    public void testMigrateV3() {
        this.testMigrate(3);
    }

    private void testMigrate(int version) {
        this.migrationService.migrate(Integer.valueOf(version), this.fileSystem);
        Collections.sort(this.migrationList, Comparator.comparingInt(StorageMigration::getTargetVersion));
        for (int i = 0; i < this.migrationList.size(); ++i) {
            ((StorageMigration)Mockito.verify((Object)this.migrationList.get(i), (VerificationMode)(i + 1 <= version ? Mockito.times((int)1) : Mockito.never()))).migrate((FileSystem)Matchers.eq((Object)this.fileSystem));
        }
    }
}

