/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.impl;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.impl.ExperimentalFeatureDefRegistryImpl;
import org.uberfire.experimental.service.events.PortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.ExperimentalFeaturesStorage;
import org.uberfire.experimental.service.storage.impl.ExperimentalFeaturesStorageImpl;
import org.uberfire.experimental.service.storage.migration.StorageMigrationService;
import org.uberfire.experimental.service.storage.scoped.impl.GlobalExperimentalFeaturesStorageImpl;
import org.uberfire.experimental.service.storage.scoped.impl.UserExperimentalFeaturesStorageImpl;
import org.uberfire.experimental.service.storage.util.ExperimentalConstants;
import org.uberfire.experimental.service.util.TestUtils;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class ExperimentalFeaturesStorageImplTest {
    private static final String USER_NAME = "my-user";
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    private SessionInfo sessionInfo;
    @Mock
    protected SpacesAPI spaces;
    @Mock
    protected IOService ioService;
    @Mock
    protected ExperimentalFeatureDefRegistryImpl defRegistry;
    private FileSystem fileSystem;
    @Mock
    private StorageMigrationService storageMigrationService;
    @Mock
    private EventSourceMock<PortableExperimentalFeatureModifiedEvent> event;
    private ExperimentalFeaturesStorageImpl storage;
    private GlobalExperimentalFeaturesStorageImpl globalStorage;
    private UserExperimentalFeaturesStorageImpl userStorage;

    @Before
    public void init() throws IOException {
        MappingContextSingleton.get();
        fileSystemTestingUtils.setup();
        this.sessionInfo = new SessionInfoMock(USER_NAME);
        this.fileSystem = fileSystemTestingUtils.getFileSystem();
        this.ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).endBatch();
        ((IOService)Mockito.doReturn((Object)this.fileSystem).when((Object)this.ioService)).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
        this.defRegistry = TestUtils.getRegistry();
        this.globalStorage = (GlobalExperimentalFeaturesStorageImpl)Mockito.spy((Object)new GlobalExperimentalFeaturesStorageImpl(this.sessionInfo, this.ioService, (ExperimentalFeatureDefRegistry)this.defRegistry, this.event));
        this.userStorage = (UserExperimentalFeaturesStorageImpl)Mockito.spy((Object)new UserExperimentalFeaturesStorageImpl(this.sessionInfo, this.ioService, (ExperimentalFeatureDefRegistry)this.defRegistry));
    }

    private void initSkipMigration() {
        this.ioService.write(this.fileSystem.getPath("/experimental/.settings", new String[0]), "version=2", new OpenOption[0]);
        this.initStorage();
        ((StorageMigrationService)Mockito.verify((Object)this.storageMigrationService, (VerificationMode)Mockito.never())).migrate((Integer)Matchers.any(), (FileSystem)Matchers.any());
    }

    private void initStorage() {
        Instance instance = (Instance)Mockito.mock(Instance.class);
        ArrayList<Object> storages = new ArrayList<Object>();
        storages.add(this.userStorage);
        storages.add(this.globalStorage);
        Mockito.when((Object)instance.iterator()).thenReturn(storages.iterator());
        this.storage = new ExperimentalFeaturesStorageImpl(this.spaces, this.ioService, (ExperimentalFeatureDefRegistry)this.defRegistry, instance, this.storageMigrationService);
        this.storage.init();
        this.verifyInit();
    }

    @Test
    public void testStoreUserLevelFeature() {
        this.initSkipMigration();
        this.testStoreFeature("feature_1", false, (ExperimentalFeaturesStorage)this.userStorage, (ExperimentalFeaturesStorage)this.globalStorage, 1);
        this.testStoreFeature("feature_2", true, (ExperimentalFeaturesStorage)this.userStorage, (ExperimentalFeaturesStorage)this.globalStorage, 2);
        this.testStoreFeature("feature_3", true, (ExperimentalFeaturesStorage)this.userStorage, (ExperimentalFeaturesStorage)this.globalStorage, 3);
    }

    @Test
    public void testStoreGlobalFeature() {
        this.initSkipMigration();
        this.testStoreFeature("globalFeature_1", false, (ExperimentalFeaturesStorage)this.globalStorage, (ExperimentalFeaturesStorage)this.userStorage, 1);
        this.testStoreFeature("globalFeature_2", true, (ExperimentalFeaturesStorage)this.globalStorage, (ExperimentalFeaturesStorage)this.userStorage, 2);
        this.testStoreFeature("globalFeature_3", true, (ExperimentalFeaturesStorage)this.globalStorage, (ExperimentalFeaturesStorage)this.userStorage, 3);
    }

    @Test
    public void testMigrationWithoutSettingsFile() {
        this.initStorage();
        ((StorageMigrationService)Mockito.verify((Object)this.storageMigrationService)).migrate(ExperimentalConstants.EXPERIMENTAL_VERSION, this.fileSystem);
    }

    @Test
    public void testMigrationWithSettingsFileOldVersion() {
        this.ioService.write(this.fileSystem.getPath("/experimental/.settings", new String[0]), "version=1", new OpenOption[0]);
        this.initStorage();
        ((StorageMigrationService)Mockito.verify((Object)this.storageMigrationService)).migrate(ExperimentalConstants.EXPERIMENTAL_VERSION, this.fileSystem);
    }

    private void testStoreFeature(String featureId, boolean newValue, ExperimentalFeaturesStorage storage, ExperimentalFeaturesStorage otherStorage, int times) {
        this.storage.store(new ExperimentalFeatureImpl(featureId, newValue));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ExperimentalFeatureImpl.class);
        ((ExperimentalFeaturesStorage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)times))).store((ExperimentalFeatureImpl)captor.capture());
        ((ExperimentalFeaturesStorage)Mockito.verify((Object)otherStorage, (VerificationMode)Mockito.never())).store((ExperimentalFeatureImpl)Matchers.any());
        ExperimentalFeatureImpl feature = (ExperimentalFeatureImpl)captor.getValue();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)feature).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)featureId)).hasFieldOrPropertyWithValue("enabled", (Object)newValue);
    }

    @After
    public void clean() {
        this.ioService.delete(this.fileSystem.getPath(this.globalStorage.getStoragePath(), new String[0]), new DeleteOption[0]);
        this.ioService.delete(this.fileSystem.getPath(this.userStorage.getStoragePath(), new String[0]), new DeleteOption[0]);
        fileSystemTestingUtils.cleanup();
    }

    private void verifyInit() {
        ((SpacesAPI)Mockito.verify((Object)this.spaces)).resolveFileSystemURI((SpacesAPI.Scheme)Matchers.any(), (Space)Matchers.any(), (String)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService)).newFileSystem((URI)Matchers.any(), (Map)Matchers.any());
        ((IterableAssert)Assertions.assertThat((Iterable)this.storage.getFeatures()).isNotNull()).hasSize(6);
    }
}

