/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.scoped.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.After;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.experimental.service.definition.impl.ExperimentalFeatureDefRegistryImpl;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.scoped.impl.AbstractScopedExperimentalFeaturesStorage;
import org.uberfire.experimental.service.util.TestUtils;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;

public abstract class AbstractExperimentalFeaturesStorageTest<STORAGE extends AbstractScopedExperimentalFeaturesStorage> {
    protected static final String USER_NAME = "my-user";
    protected static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    protected SessionInfo sessionInfo;
    protected IOService ioService;
    @Mock
    protected ExperimentalFeatureDefRegistryImpl defRegistry;
    protected FileSystem fileSystem;
    protected STORAGE storage;

    @Before
    public void init() throws IOException {
        MappingContextSingleton.get();
        fileSystemTestingUtils.setup();
        this.sessionInfo = new SessionInfoMock(USER_NAME);
        this.fileSystem = fileSystemTestingUtils.getFileSystem();
        this.ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).endBatch();
        this.defRegistry = TestUtils.getRegistry();
        this.storage = this.getStorageInstance();
    }

    abstract STORAGE getStorageInstance();

    protected void verifyLoadedFeatures(List<ExperimentalFeatureImpl> features, ExperimentalFeature feature1, ExperimentalFeature feature2, ExperimentalFeature feature3) {
        features.sort(Comparator.comparing(ExperimentalFeatureImpl::getFeatureId));
        ((ListAssert)Assertions.assertThat(features).isNotNull()).hasSize(3);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)features.get(0)).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)feature1.getFeatureId())).hasFieldOrPropertyWithValue("enabled", (Object)feature1.isEnabled());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)features.get(1)).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)feature2.getFeatureId())).hasFieldOrPropertyWithValue("enabled", (Object)feature2.isEnabled());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)features.get(2)).isNotNull()).hasFieldOrPropertyWithValue("featureId", (Object)feature3.getFeatureId())).hasFieldOrPropertyWithValue("enabled", (Object)feature3.isEnabled());
    }

    @After
    public void clean() {
        fileSystemTestingUtils.cleanup();
        try {
            this.ioService.delete(this.fileSystem.getPath(this.storage.getStoragePath(), new String[0]), new DeleteOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

