/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.scoped.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.scoped.impl.AbstractExperimentalFeaturesStorageTest;
import org.uberfire.experimental.service.storage.scoped.impl.UserExperimentalFeaturesStorageImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=MockitoJUnitRunner.class)
public class UserExperimentalFeaturesStorageImplTest
extends AbstractExperimentalFeaturesStorageTest<UserExperimentalFeaturesStorageImpl> {
    @Test
    public void testFirstLoad() {
        ((UserExperimentalFeaturesStorageImpl)this.storage).init(this.fileSystem);
        ArrayList<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>(((UserExperimentalFeaturesStorageImpl)this.storage).getFeatures());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).exists((Path)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).newInputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).createDirectory((Path)Matchers.any(), new FileAttribute[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        this.verifyLoadedFeatures(features, (ExperimentalFeature)new ExperimentalFeatureImpl("feature_1", false), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_3", false));
    }

    @Test
    public void testRegularLoad() throws IOException {
        Path path = this.fileSystem.getPath(((UserExperimentalFeaturesStorageImpl)this.storage).getStoragePath(), new String[0]);
        this.ioService.write(path, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/user/regularFeatures.txt"), (Charset)Charset.defaultCharset()), new OpenOption[0]);
        ((UserExperimentalFeaturesStorageImpl)this.storage).init(this.fileSystem);
        ArrayList<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>(((UserExperimentalFeaturesStorageImpl)this.storage).getFeatures());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)3))).exists((Path)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).createDirectory((Path)Matchers.any(), new FileAttribute[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).newInputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).endBatch();
        this.verifyLoadedFeatures(features, (ExperimentalFeature)new ExperimentalFeatureImpl("feature_1", true), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_3", true));
    }

    @Test
    public void testExtraFeaturesLoad() throws IOException {
        Path path = this.fileSystem.getPath(((UserExperimentalFeaturesStorageImpl)this.storage).getStoragePath(), new String[0]);
        this.ioService.write(path, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/user/extraFeatures.txt"), (Charset)Charset.defaultCharset()), new OpenOption[0]);
        ((UserExperimentalFeaturesStorageImpl)this.storage).init(this.fileSystem);
        ArrayList<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>(((UserExperimentalFeaturesStorageImpl)this.storage).getFeatures());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)3))).exists((Path)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).createDirectory((Path)Matchers.any(), new FileAttribute[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).newInputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        this.verifyLoadedFeatures(features, (ExperimentalFeature)new ExperimentalFeatureImpl("feature_1", true), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_3", true));
    }

    @Test
    public void testMissingFeaturesLoad() throws IOException {
        Path path = this.fileSystem.getPath(((UserExperimentalFeaturesStorageImpl)this.storage).getStoragePath(), new String[0]);
        this.ioService.write(path, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/user/missingFeatures.txt"), (Charset)Charset.defaultCharset()), new OpenOption[0]);
        ((UserExperimentalFeaturesStorageImpl)this.storage).init(this.fileSystem);
        ArrayList<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>(((UserExperimentalFeaturesStorageImpl)this.storage).getFeatures());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)3))).exists((Path)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).createDirectory((Path)Matchers.any(), new FileAttribute[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).newInputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        this.verifyLoadedFeatures(features, (ExperimentalFeature)new ExperimentalFeatureImpl("feature_1", true), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_3", true));
    }

    @Test
    public void testStoreFeature() throws IOException {
        this.testRegularLoad();
        ((UserExperimentalFeaturesStorageImpl)this.storage).store(new ExperimentalFeatureImpl("globalFeature_1", true));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).endBatch();
        ((UserExperimentalFeaturesStorageImpl)this.storage).store(new ExperimentalFeatureImpl("feature_1", false));
        ((IOService)Mockito.verify((Object)this.ioService)).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        this.verifyLoadedFeatures(new ArrayList<ExperimentalFeatureImpl>(((UserExperimentalFeaturesStorageImpl)this.storage).getFeatures()), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_1", false), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("feature_3", true));
    }

    @Override
    protected UserExperimentalFeaturesStorageImpl getStorageInstance() {
        return new UserExperimentalFeaturesStorageImpl(this.sessionInfo, this.ioService, (ExperimentalFeatureDefRegistry)this.defRegistry);
    }
}

