/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.migration.impl.migrations;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.experimental.service.storage.migration.StorageMigration;
import org.uberfire.experimental.service.storage.scoped.impl.UserExperimentalFeaturesStorageImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@Dependent
public class V2StorageMigration
implements StorageMigration {
    private IOService ioService;

    @Inject
    public V2StorageMigration(@Named(value="configIO") IOService ioService) {
        this.ioService = ioService;
    }

    @Override
    public int getTargetVersion() {
        return 2;
    }

    @Override
    public void migrate(FileSystem fileSystem) {
        Path usersRoot = fileSystem.getPath("/experimental/users", new String[0]);
        try (DirectoryStream stream = this.ioService.newDirectoryStream(usersRoot);){
            stream.forEach(folder -> {
                String folderName = Paths.convert((Path)folder).getFileName();
                Path newFolder = usersRoot.resolve(UserExperimentalFeaturesStorageImpl.encode(folderName));
                this.ioService.move(folder, newFolder, new CopyOption[0]);
            });
        }
    }
}

