/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.migration.impl.migrations;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.uberfire.experimental.service.storage.migration.impl.migrations.V2StorageMigration;
import org.uberfire.experimental.service.storage.scoped.impl.UserExperimentalFeaturesStorageImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.FileSystemTestingUtils;

public class V2StorageMigrationTest {
    private static final List<String> usernames = Arrays.asList("pere", "eder", "tiago");
    protected static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    protected IOService ioService;
    protected FileSystem fileSystem;
    private V2StorageMigration migration;
    private String fileContent;

    @Before
    public void init() throws IOException {
        MappingContextSingleton.get();
        fileSystemTestingUtils.setup();
        this.ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        this.fileSystem = fileSystemTestingUtils.getFileSystem();
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).startBatch((FileSystem)ArgumentMatchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)this.ioService)).endBatch();
        this.fileContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/global/regularFeatures.txt"), (Charset)Charset.defaultCharset());
        usernames.forEach(this::createExperimentalSettings);
        this.migration = new V2StorageMigration(this.ioService);
    }

    private void createExperimentalSettings(String userName) {
        Path path = this.fileSystem.getPath(MessageFormat.format("/experimental/users/{0}/.experimental", userName), new String[0]);
        this.ioService.write(path, this.fileContent, new OpenOption[0]);
        Assert.assertTrue((boolean)this.ioService.exists(path));
    }

    @Test
    public void testMigration() {
        this.migration.migrate(this.fileSystem);
        usernames.forEach(this::validateUserSettings);
    }

    private void validateUserSettings(String userName) {
        Path oldPath = this.fileSystem.getPath(MessageFormat.format("/experimental/users/{0}/.experimental", userName), new String[0]);
        Assert.assertFalse((boolean)this.ioService.exists(oldPath));
        String encodedName = UserExperimentalFeaturesStorageImpl.encode((String)userName);
        Path newPath = this.fileSystem.getPath(MessageFormat.format("/experimental/users/{0}/.experimental", encodedName), new String[0]);
        Assert.assertTrue((boolean)this.ioService.exists(newPath));
        ((AbstractStringAssert)Assertions.assertThat((String)this.ioService.readAllString(newPath)).isNotBlank()).isEqualTo(this.fileContent);
    }

    @After
    public void cleanup() {
        fileSystemTestingUtils.cleanup();
    }
}

