/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.editor;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.experimental.client.editor.ExperimentalFeaturesEditorScreenView;
import org.uberfire.experimental.client.editor.group.ExperimentalFeaturesGroup;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.experimental.service.editor.FeaturesEditorService;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.ExperimentalFeaturesRegistry;
import org.uberfire.experimental.service.security.GlobalExperimentalFeatureAction;
import org.uberfire.experimental.service.security.GlobalExperimentalFeatureResourceType;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
@WorkbenchScreen(identifier="ExperimentalFeaturesEditor")
public class ExperimentalFeaturesEditorScreen
implements ExperimentalFeaturesEditorScreenView.Presenter {
    public static final String SCREEN_ID = "ExperimentalFeaturesEditor";
    private final TranslationService translationService;
    private final ClientExperimentalFeaturesRegistryService registryService;
    private final ExperimentalFeatureDefRegistry defRegistry;
    private final ExperimentalFeaturesEditorScreenView view;
    private final ManagedInstance<ExperimentalFeaturesGroup> groupsInstance;
    private final Caller<FeaturesEditorService> editorService;
    private final SessionInfo sessionInfo;
    private final AuthorizationManager authorizationManager;

    @Inject
    public ExperimentalFeaturesEditorScreen(TranslationService translationService, ClientExperimentalFeaturesRegistryService registryService, ExperimentalFeatureDefRegistry defRegistry, ExperimentalFeaturesEditorScreenView view, ManagedInstance<ExperimentalFeaturesGroup> groupsInstance, Caller<FeaturesEditorService> editorService, SessionInfo sessionInfo, AuthorizationManager authorizationManager) {
        this.translationService = translationService;
        this.registryService = registryService;
        this.defRegistry = defRegistry;
        this.view = view;
        this.groupsInstance = groupsInstance;
        this.editorService = editorService;
        this.sessionInfo = sessionInfo;
        this.authorizationManager = authorizationManager;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @OnOpen
    public void show() {
        Map groupedFeatures;
        TreeSet groups;
        this.clear();
        ExperimentalFeaturesRegistry registry = this.registryService.getFeaturesRegistry();
        if (registry != null && !(groups = (groupedFeatures = registry.getAllFeatures().stream().collect(Collectors.groupingBy(this::getFeatureGroupName, Collectors.toSet()))).entrySet().stream().map(this::getFeaturesGroup).filter(Objects::nonNull).collect(Collectors.toCollection(TreeSet::new))).isEmpty()) {
            ((ExperimentalFeaturesGroup)groups.first()).expand();
            groups.forEach(this.view::add);
        }
    }

    private String getFeatureGroupName(ExperimentalFeature feature) {
        ExperimentalFeatureDefinition definition = this.defRegistry.getFeatureById(feature.getFeatureId());
        if (definition.isGlobal()) {
            return "experimentalFeatures.globalGroup";
        }
        if (definition.getGroup().isEmpty()) {
            return "experimentalFeatures.generalGroup";
        }
        return definition.getGroup();
    }

    private ExperimentalFeaturesGroup getFeaturesGroup(Map.Entry<String, Set<ExperimentalFeature>> entry) {
        String groupName = entry.getKey();
        if (groupName.equals("experimentalFeatures.globalGroup") && !this.authorizationManager.authorize((ResourceType)new GlobalExperimentalFeatureResourceType(), (ResourceAction)GlobalExperimentalFeatureAction.EDIT, this.sessionInfo.getIdentity())) {
            return null;
        }
        ExperimentalFeaturesGroup group = (ExperimentalFeaturesGroup)this.groupsInstance.get();
        group.init(groupName, (Collection<ExperimentalFeature>)entry.getValue(), (ParameterizedCommand<EditableExperimentalFeature>)((ParameterizedCommand)this::doSave));
        return group;
    }

    protected void doSave(EditableExperimentalFeature feature) {
        ((FeaturesEditorService)this.editorService.call(aVoid -> this.registryService.updateExperimentalFeature(feature.getFeatureId(), feature.isEnabled()))).save(feature);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.getTranslation("ExperimentalFeaturesEditorScreenViewImpl.experimentalFeaturesTitle");
    }

    @WorkbenchPartView
    public ExperimentalFeaturesEditorScreenView getView() {
        return this.view;
    }

    @PreDestroy
    public void clear() {
        this.view.clear();
        this.groupsInstance.destroyAll();
    }
}

