/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.editor.group;

import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.experimental.client.editor.group.ExperimentalFeaturesGroupView;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditor;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class ExperimentalFeaturesGroup
implements IsElement,
ExperimentalFeaturesGroupView.Presenter,
Comparable<ExperimentalFeaturesGroup> {
    private final ExperimentalFeaturesGroupView view;
    private final TranslationService translationService;
    private final ManagedInstance<ExperimentalFeatureEditor> editorInstance;
    protected String labelKey;
    protected List<ExperimentalFeatureEditor> editors = new ArrayList<ExperimentalFeatureEditor>();
    protected ParameterizedCommand<EditableExperimentalFeature> callback;
    private boolean expanded = false;
    private boolean enableAllRunning = false;

    @Inject
    public ExperimentalFeaturesGroup(ExperimentalFeaturesGroupView view, TranslationService translationService, ManagedInstance<ExperimentalFeatureEditor> editorInstance) {
        this.view = view;
        this.translationService = translationService;
        this.editorInstance = editorInstance;
        view.init(this);
    }

    public void init(String labelKey, Collection<ExperimentalFeature> features, ParameterizedCommand<EditableExperimentalFeature> callback) {
        PortablePreconditions.checkNotNull((String)"labelKey", (Object)labelKey);
        PortablePreconditions.checkNotNull((String)"features", features);
        PortablePreconditions.checkNotNull((String)"callback", callback);
        this.clear();
        this.labelKey = labelKey;
        this.callback = feature -> {
            callback.execute(feature);
            this.setEnableAllLabel();
        };
        this.view.setLabel(this.getLabel());
        features.stream().map(this::getEditor).collect(Collectors.toCollection(TreeSet::new)).forEach(this.view::render);
        this.setEnableAllLabel();
    }

    private void setEnableAllLabel() {
        if (!this.enableAllRunning) {
            if (this.isSelectAll()) {
                this.view.setEnableAllLabel(this.translationService.getTranslation("ExperimentalFeaturesGroup.enableAll"));
            } else {
                this.view.setEnableAllLabel(this.translationService.getTranslation("ExperimentalFeaturesGroup.disableAll"));
            }
        }
    }

    private boolean isSelectAll() {
        long enabled = this.editors.stream().filter(ExperimentalFeatureEditor::isEnabled).count();
        return enabled != (long)this.editors.size();
    }

    private ExperimentalFeatureEditor getEditor(ExperimentalFeature experimentalFeature) {
        ExperimentalFeatureEditor editor = (ExperimentalFeatureEditor)this.editorInstance.get();
        editor.render(new EditableExperimentalFeature(experimentalFeature), this.callback);
        this.editors.add(editor);
        return editor;
    }

    @Override
    public void doEnableAll() {
        boolean select = this.isSelectAll();
        this.enableAllRunning = true;
        this.editors.stream().filter(editor -> editor.isEnabled() != select).forEach(editor -> editor.enable());
        this.enableAllRunning = false;
        this.setEnableAllLabel();
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public int compareTo(ExperimentalFeaturesGroup other) {
        if ("experimentalFeatures.generalGroup".equals(this.labelKey) || "experimentalFeatures.globalGroup".equals(other.labelKey)) {
            return Integer.MIN_VALUE;
        }
        if ("experimentalFeatures.globalGroup".equals(this.labelKey) || "experimentalFeatures.generalGroup".equals(other.labelKey)) {
            return Integer.MAX_VALUE;
        }
        return this.getLabel().compareTo(other.getLabel());
    }

    public void expand() {
        if (!this.expanded) {
            this.expanded = true;
            this.view.expand();
        }
    }

    public void collapse() {
        if (this.expanded) {
            this.expanded = false;
            this.view.collapse();
        }
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void notifyExpand() {
        this.expanded = !this.expanded;
        this.view.arrangeCaret();
    }

    @Override
    public String getLabel() {
        String translation = this.translationService.getTranslation(this.labelKey);
        if (translation == null) {
            translation = this.labelKey;
        }
        return translation;
    }

    @PreDestroy
    public void clear() {
        this.editors.clear();
        this.view.clear();
        this.editorInstance.destroyAll();
        this.enableAllRunning = false;
    }
}

