/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.disabled.component;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.client.disabled.component.DisabledFeatureComponent;
import org.uberfire.experimental.client.disabled.component.DisabledFeatureComponentView;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;

@RunWith(value=MockitoJUnitRunner.class)
public class DisabledFeatureComponentTest {
    private String EXPERIMENTAL_FEATURE_ID = "a random id";
    @Mock
    private DisabledFeatureComponentView view;
    @Mock
    private ExperimentalFeatureDefRegistry registry;
    @Mock
    private TranslationService translationService;
    private DisabledFeatureComponent component;

    @Before
    public void init() {
        this.component = new DisabledFeatureComponent(this.view, this.registry, this.translationService);
    }

    @Test
    public void testShowMissingExperimentalFeature() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.component.show(this.EXPERIMENTAL_FEATURE_ID)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'experimentalFeature' should be not null!");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation(Matchers.anyString());
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format(Matchers.anyString(), new Object[]{Matchers.anyString()});
        ((DisabledFeatureComponentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).show(Matchers.anyString());
    }

    @Test
    public void testShowExperimentalFeature() {
        this.testShowExperimentalFeature(false);
    }

    @Test
    public void testShowGlobalExperimentalFeature() {
        this.testShowExperimentalFeature(true);
    }

    private void testShowExperimentalFeature(boolean global) {
        ExperimentalFeatureDefinition definition = new ExperimentalFeatureDefinition(this.EXPERIMENTAL_FEATURE_ID, global, "", this.EXPERIMENTAL_FEATURE_ID, this.EXPERIMENTAL_FEATURE_ID);
        Mockito.when((Object)this.registry.getFeatureById((String)Matchers.eq((Object)this.EXPERIMENTAL_FEATURE_ID))).thenReturn((Object)definition);
        this.component.show(this.EXPERIMENTAL_FEATURE_ID);
        ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation(this.EXPERIMENTAL_FEATURE_ID);
        String i18nConstant = global ? "DisabledGlobalExperimentalFeature" : "DisabledExperimentalFeature";
        ((TranslationService)Mockito.verify((Object)this.translationService)).format((String)Matchers.eq((Object)i18nConstant), new Object[]{Matchers.anyString()});
        ((DisabledFeatureComponentView)Mockito.verify((Object)this.view)).show(Matchers.anyString());
    }
}

