/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.workbench.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.inject.Specializes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.Factory;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.impl.ClientTypeRegistryImpl;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.ExperimentalFeaturesRegistry;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@Specializes
public class ExperimentalAwareClientTypeRegistryImpl
extends ClientTypeRegistryImpl {
    private ClientExperimentalFeaturesRegistryService registryService;
    private Map<Class<?>, String> resourceTypeToExperimentalFeature = new HashMap();

    @Inject
    public ExperimentalAwareClientTypeRegistryImpl(SyncBeanManager iocManager, ClientExperimentalFeaturesRegistryService registryService) {
        super(iocManager);
        this.registryService = registryService;
    }

    public void init() {
        super.init();
        Collection resourceTypeDefs = this.iocManager.lookupBeans(ResourceTypeDefinition.class);
        List clientResourceTypes = resourceTypeDefs.stream().filter(def -> def.isAssignableTo(ClientResourceType.class)).collect(Collectors.toList());
        List resourceTypes = resourceTypeDefs.stream().filter(def -> !def.isAssignableTo(ClientResourceType.class)).collect(Collectors.toList());
        clientResourceTypes.stream().forEach(clientResourceDef -> {
            Iterator it = resourceTypes.iterator();
            while (it.hasNext()) {
                Optional<ExperimentalFeature> optional;
                SyncBeanDef resourceDef = (SyncBeanDef)it.next();
                if (!clientResourceDef.isAssignableTo(resourceDef.getBeanClass()) || !(optional = this.getFeatureForResourceType((SyncBeanDef<ResourceTypeDefinition>)resourceDef, (SyncBeanDef<ResourceTypeDefinition>)clientResourceDef)).isPresent()) continue;
                ExperimentalFeature feature = optional.get();
                this.resourceTypeToExperimentalFeature.put(resourceDef.getBeanClass(), feature.getFeatureId());
                this.resourceTypeToExperimentalFeature.put(clientResourceDef.getBeanClass(), feature.getFeatureId());
                it.remove();
            }
        });
    }

    private Optional<ExperimentalFeature> getFeatureForResourceType(SyncBeanDef<ResourceTypeDefinition> resourceType, SyncBeanDef<ResourceTypeDefinition> clientResourceType) {
        ExperimentalFeaturesRegistry registry = this.registryService.getFeaturesRegistry();
        Optional optional = registry.getFeature(resourceType.getBeanClass().getName());
        if (optional.isPresent()) {
            return optional;
        }
        return registry.getFeature(clientResourceType.getBeanClass().getName());
    }

    public boolean isEnabled(ClientResourceType resourceType) {
        if (super.isEnabled(resourceType)) {
            Optional<String> optional = Optional.ofNullable(this.resourceTypeToExperimentalFeature.get((resourceType = (ClientResourceType)Factory.maybeUnwrapProxy((Object)resourceType)).getClass()));
            if (optional.isPresent()) {
                return this.registryService.isFeatureEnabled(optional.get());
            }
            return true;
        }
        return false;
    }
}

