/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.workbench.type;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.experimental.client.workbench.type.ExperimentalAwareClientTypeRegistryImpl;
import org.uberfire.experimental.client.workbench.type.test.api.DiagramResourceType;
import org.uberfire.experimental.client.workbench.type.test.api.FormResourceType;
import org.uberfire.experimental.client.workbench.type.test.api.JavaResourceType;
import org.uberfire.experimental.client.workbench.type.test.api.TextFileResourceType;
import org.uberfire.experimental.client.workbench.type.test.api.WrongClientResourceType;
import org.uberfire.experimental.client.workbench.type.test.client.ClientDiagramResourceType;
import org.uberfire.experimental.client.workbench.type.test.client.ClientFormResourceType;
import org.uberfire.experimental.client.workbench.type.test.client.ClientJavaResourceType;
import org.uberfire.experimental.client.workbench.type.test.client.ClientSpreadSheetResourceType;
import org.uberfire.experimental.client.workbench.type.test.client.ClientTextFileResourceType;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeaturesRegistryImpl;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@RunWith(value=MockitoJUnitRunner.class)
public class ExperimentalAwareClientTypeRegistryImplTest {
    private ExperimentalAwareClientTypeRegistryImpl clientTypeRegistry;
    @Mock
    private SyncBeanManager manager;
    @Mock
    private ClientExperimentalFeaturesRegistryService experimentalFeaturesRegistryService;
    private ClientJavaResourceType clientJavaResourceType = new ClientJavaResourceType();
    private ClientFormResourceType clientFormResourceType = new ClientFormResourceType();
    private ClientDiagramResourceType clientDiagramResourceType = new ClientDiagramResourceType();
    private ClientTextFileResourceType clientTextFileResourceType = new ClientTextFileResourceType();
    private ClientSpreadSheetResourceType clientSpreadSheetResourceType = new ClientSpreadSheetResourceType();
    private List<SyncBeanDef<ClientResourceType>> clientTypes = new ArrayList<SyncBeanDef<ClientResourceType>>();
    private List<SyncBeanDef<ResourceTypeDefinition>> allResourceTypes = new ArrayList<SyncBeanDef<ResourceTypeDefinition>>();

    @Before
    public void init() {
        ArrayList<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>();
        features.add(new ExperimentalFeatureImpl(JavaResourceType.class.getName(), true));
        features.add(new ExperimentalFeatureImpl(ClientFormResourceType.class.getName(), false));
        features.add(new ExperimentalFeatureImpl(TextFileResourceType.class.getName(), false));
        features.add(new ExperimentalFeatureImpl(ClientSpreadSheetResourceType.class.getName(), true));
        ExperimentalFeaturesRegistryImpl experimentalFeaturesRegistry = new ExperimentalFeaturesRegistryImpl(features);
        Mockito.when((Object)this.experimentalFeaturesRegistryService.getFeaturesRegistry()).thenReturn((Object)experimentalFeaturesRegistry);
        Mockito.when((Object)this.experimentalFeaturesRegistryService.isFeatureEnabled(Matchers.anyString())).thenAnswer(invocationOnMock -> experimentalFeaturesRegistry.isFeatureEnabled(invocationOnMock.getArguments()[0].toString()));
        this.clientTypes.add(this.createBeanDef(ClientJavaResourceType.class, this.clientJavaResourceType));
        this.clientTypes.add(this.createBeanDef(ClientFormResourceType.class, this.clientFormResourceType));
        this.clientTypes.add(this.createBeanDef(ClientDiagramResourceType.class, this.clientDiagramResourceType));
        this.clientTypes.add(this.createBeanDef(ClientTextFileResourceType.class, this.clientTextFileResourceType));
        this.clientTypes.add(this.createBeanDef(ClientSpreadSheetResourceType.class, this.clientSpreadSheetResourceType));
        Mockito.when((Object)this.manager.lookupBeans(ClientResourceType.class)).thenReturn(this.clientTypes);
        this.allResourceTypes.add(this.createBeanDef(ClientJavaResourceType.class, this.clientJavaResourceType));
        this.allResourceTypes.add(this.createBeanDef(ClientFormResourceType.class, this.clientFormResourceType));
        this.allResourceTypes.add(this.createBeanDef(ClientDiagramResourceType.class, this.clientDiagramResourceType));
        this.allResourceTypes.add(this.createBeanDef(ClientTextFileResourceType.class, this.clientTextFileResourceType));
        this.allResourceTypes.add(this.createBeanDef(ClientSpreadSheetResourceType.class, this.clientSpreadSheetResourceType));
        this.allResourceTypes.add(this.createBeanDef(JavaResourceType.class, null));
        this.allResourceTypes.add(this.createBeanDef(FormResourceType.class, null));
        this.allResourceTypes.add(this.createBeanDef(DiagramResourceType.class, null));
        this.allResourceTypes.add(this.createBeanDef(TextFileResourceType.class, null));
        Mockito.when((Object)this.manager.lookupBeans(ResourceTypeDefinition.class)).thenReturn(this.allResourceTypes);
        this.clientTypeRegistry = new ExperimentalAwareClientTypeRegistryImpl(this.manager, this.experimentalFeaturesRegistryService);
        this.clientTypeRegistry.init();
    }

    @Test
    public void testResourceTypes() {
        Assertions.assertThat((Iterable)this.clientTypeRegistry.getRegisteredTypes()).hasSize(this.clientTypes.size());
    }

    @Test
    public void testIsEnabled() {
        Assert.assertTrue((boolean)this.clientTypeRegistry.isEnabled((ClientResourceType)this.clientJavaResourceType));
        Assert.assertFalse((boolean)this.clientTypeRegistry.isEnabled((ClientResourceType)this.clientFormResourceType));
        Assert.assertTrue((boolean)this.clientTypeRegistry.isEnabled((ClientResourceType)this.clientDiagramResourceType));
        Assert.assertFalse((boolean)this.clientTypeRegistry.isEnabled((ClientResourceType)this.clientTextFileResourceType));
        Assert.assertTrue((boolean)this.clientTypeRegistry.isEnabled((ClientResourceType)this.clientSpreadSheetResourceType));
        Assert.assertFalse((boolean)this.clientTypeRegistry.isEnabled((ClientResourceType)new WrongClientResourceType()));
    }

    private SyncBeanDef<?> createBeanDef(Class resourceType, Object instance) {
        SyncBeanDef def = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)def.getBeanClass()).thenReturn((Object)resourceType);
        Mockito.when((Object)def.getInstance()).thenReturn(instance);
        Mockito.when((Object)def.isAssignableTo((Class)Matchers.any())).thenAnswer(invocationOnMock -> {
            Class parentType = (Class)invocationOnMock.getArguments()[0];
            return parentType.isAssignableFrom(resourceType);
        });
        return def;
    }
}

