/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.service.impl;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.experimental.service.backend.BackendExperimentalFeaturesRegistryService;
import org.uberfire.experimental.service.backend.impl.ExperimentalFeaturesSessionImpl;
import org.uberfire.experimental.service.events.NonPortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.events.PortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.ExperimentalFeaturesRegistry;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;

@ApplicationScoped
public class ClientExperimentalFeaturesRegistryServiceImpl
implements ClientExperimentalFeaturesRegistryService {
    private Caller<BackendExperimentalFeaturesRegistryService> backendService;
    private Event<NonPortableExperimentalFeatureModifiedEvent> event;
    private ExperimentalFeaturesSessionImpl session;

    @Inject
    public ClientExperimentalFeaturesRegistryServiceImpl(Caller<BackendExperimentalFeaturesRegistryService> backendService, Event<NonPortableExperimentalFeatureModifiedEvent> event) {
        this.backendService = backendService;
        this.event = event;
    }

    @Override
    public void loadRegistry() {
        ((BackendExperimentalFeaturesRegistryService)this.backendService.call(experimentalFeaturesSession -> {
            this.session = experimentalFeaturesSession;
        })).getExperimentalFeaturesSession();
    }

    public ExperimentalFeaturesRegistry getFeaturesRegistry() {
        return this.session.getFeaturesRegistry();
    }

    public boolean isFeatureEnabled(String featureId) {
        if (this.isExperimentalEnabled().booleanValue()) {
            return this.getFeaturesRegistry().isFeatureEnabled(featureId);
        }
        return !this.getFeaturesRegistry().getFeature(featureId).isPresent();
    }

    @Override
    public void updateExperimentalFeature(String featureId, boolean enabled) {
        ExperimentalFeatureImpl feature;
        Optional optional;
        if (this.isExperimentalEnabled().booleanValue() && (optional = this.session.getFeaturesRegistry().getFeature(featureId)).isPresent() && (feature = (ExperimentalFeatureImpl)optional.get()).isEnabled() != enabled) {
            feature.setEnabled(enabled);
            this.event.fire((Object)new NonPortableExperimentalFeatureModifiedEvent((ExperimentalFeature)feature));
        }
    }

    public Boolean isExperimentalEnabled() {
        return this.session.isExperimentalFeaturesEnabled();
    }

    public void onGlobalFeatureModified(@Observes PortableExperimentalFeatureModifiedEvent event) {
        this.updateExperimentalFeature(event.getFeature().getFeatureId(), event.getFeature().isEnabled());
    }
}

