/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.service.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.menu.events.PerspectiveVisibiltiyChangeEvent;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.experimental.client.service.auth.ExperimentalActivitiesAuthorizationManagerImpl;
import org.uberfire.experimental.client.service.auth.ExperimentalActivityReference;
import org.uberfire.experimental.client.test.TestExperimentalActivityReference;
import org.uberfire.experimental.client.test.model.TestExperimentalScreen1Activity;
import org.uberfire.experimental.client.test.model.TestExperimentalScreen2Activity;
import org.uberfire.experimental.client.test.model.TestNonExperimentalScreenActivity;
import org.uberfire.experimental.service.events.NonPortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.events.PortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;

@RunWith(value=MockitoJUnitRunner.class)
public class ExperimentalActivitiesAuthorizationManagerImplTest {
    private static final String ACTIVITY_1_ID_TYPENAME = "org.uberfire.experimental.client.test.model.TestExperimentalScreen1Activity";
    private static final String ACTIVITY_1_ID = "TestExperimentalScreen1";
    private static final String FEATURE_1_ID = "org.uberfire.experimental.client.test.model.TestExperimentalScreen1";
    private static final String ACTIVITY_2_ID_TYPENAME = "org.uberfire.experimental.client.test.model.TestExperimentalScreen2Activity";
    private static final String ACTIVITY_2_ID = "TestExperimentalScreen2";
    private static final String FEATURE_2_ID = "org.uberfire.experimental.client.test.model.TestExperimentalScreen2";
    private static final String NON_EXPERIMENTAL_ACTIVITY_ID = "TestNonExperimentalScreen";
    @Mock
    private PlaceManager placeManager;
    @Mock
    private SyncBeanManager syncBeanManager;
    @Mock
    private ClientExperimentalFeaturesRegistryService registryService;
    @Mock
    private Event<PerspectiveVisibiltiyChangeEvent> perspectiveVisibleEvent;
    private ExperimentalActivitiesAuthorizationManagerImpl authorizationManager;

    @Before
    public void init() {
        Mockito.when((Object)this.syncBeanManager.lookupBeans(ExperimentalActivityReference.class)).thenAnswer(invocationOnMock -> this.getReferences());
        this.authorizationManager = (ExperimentalActivitiesAuthorizationManagerImpl)Mockito.spy((Object)new ExperimentalActivitiesAuthorizationManagerImpl(this.syncBeanManager, this.registryService, this.perspectiveVisibleEvent, () -> UUID.randomUUID().toString()));
        this.authorizationManager.init();
        Mockito.when((Object)this.registryService.isFeatureEnabled(FEATURE_1_ID)).thenReturn((Object)true);
        Mockito.when((Object)this.registryService.isFeatureEnabled(FEATURE_2_ID)).thenReturn((Object)false);
    }

    @Test
    public void testAuthorizeActivities() {
        Assert.assertTrue((boolean)this.authorizationManager.authorizeActivity((Object)new TestExperimentalScreen1Activity(this.placeManager)));
        ((ClientExperimentalFeaturesRegistryService)Mockito.verify((Object)this.registryService)).isFeatureEnabled(FEATURE_1_ID);
        Assert.assertFalse((boolean)this.authorizationManager.authorizeActivity((Object)new TestExperimentalScreen2Activity(this.placeManager)));
        ((ClientExperimentalFeaturesRegistryService)Mockito.verify((Object)this.registryService)).isFeatureEnabled(FEATURE_2_ID);
        Assert.assertTrue((boolean)this.authorizationManager.authorizeActivity((Object)new TestNonExperimentalScreenActivity(this.placeManager)));
        ((ClientExperimentalFeaturesRegistryService)Mockito.verify((Object)this.registryService, (VerificationMode)Mockito.times((int)2))).isFeatureEnabled(Matchers.anyString());
    }

    @Test
    public void testSecurePartWithPathPlaceRequest() {
        this.testSecure(ACTIVITY_1_ID, PathPlaceRequest.class, this::validateDoNothingSecure);
    }

    @Test
    public void testSecurePartWithExperimentalPlaceRequest() {
        this.testSecure(ACTIVITY_1_ID, DefaultPlaceRequest.class, this::validateSecure);
    }

    @Test
    public void testSecurePartWithOUTExperimentalPlaceRequest() {
        this.testSecure(NON_EXPERIMENTAL_ACTIVITY_ID, DefaultPlaceRequest.class, this::validateDoNothingSecure);
    }

    @Test
    public void testOnFeatureModifiedEvent() {
        this.testOnFeatureModified(feature -> this.authorizationManager.onFeatureModified(new NonPortableExperimentalFeatureModifiedEvent(feature)));
    }

    @Test
    public void testOnFeatureModifiedGlobalEvent() {
        this.testOnFeatureModified(feature -> this.authorizationManager.onFeatureModified(new PortableExperimentalFeatureModifiedEvent(feature)));
    }

    private void testOnFeatureModified(Consumer<ExperimentalFeature> authorizationEventConsumer) {
        authorizationEventConsumer.accept((ExperimentalFeature)new ExperimentalFeatureImpl(FEATURE_2_ID, true));
        ((Event)Mockito.verify(this.perspectiveVisibleEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
        authorizationEventConsumer.accept((ExperimentalFeature)new ExperimentalFeatureImpl(FEATURE_1_ID, true));
        ArgumentCaptor captor = ArgumentCaptor.forClass(PerspectiveVisibiltiyChangeEvent.class);
        ((Event)Mockito.verify(this.perspectiveVisibleEvent)).fire(captor.capture());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)captor.getValue()).isNotNull()).hasFieldOrPropertyWithValue("perspectiveId", (Object)ACTIVITY_1_ID)).hasFieldOrPropertyWithValue("visible", (Object)true);
        authorizationEventConsumer.accept((ExperimentalFeature)new ExperimentalFeatureImpl(FEATURE_1_ID, false));
        captor = ArgumentCaptor.forClass(PerspectiveVisibiltiyChangeEvent.class);
        ((Event)Mockito.verify(this.perspectiveVisibleEvent, (VerificationMode)Mockito.times((int)2))).fire(captor.capture());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)captor.getValue()).isNotNull()).hasFieldOrPropertyWithValue("perspectiveId", (Object)ACTIVITY_1_ID)).hasFieldOrPropertyWithValue("visible", (Object)false);
    }

    private void testSecure(String activityId, Class<? extends PlaceRequest> requestType, BiConsumer<PanelDefinition, PartDefinition> validation) {
        PlaceRequest request = (PlaceRequest)Mockito.mock(requestType);
        Mockito.when((Object)request.getIdentifier()).thenReturn((Object)activityId);
        PanelDefinition panel = (PanelDefinition)Mockito.mock(PanelDefinition.class);
        PartDefinition part = (PartDefinition)Mockito.mock(PartDefinition.class);
        Mockito.when((Object)part.getPlace()).thenReturn((Object)request);
        this.authorizationManager.securePart(part, panel);
        validation.accept(panel, part);
    }

    private void validateDoNothingSecure(PanelDefinition panel, PartDefinition part) {
        ((PanelDefinition)Mockito.verify((Object)panel, (VerificationMode)Mockito.never())).removePart(part);
        ((PartDefinition)Mockito.verify((Object)part, (VerificationMode)Mockito.never())).setPlace((PlaceRequest)Matchers.any());
    }

    private void validateSecure(PanelDefinition panel, PartDefinition part) {
        ((PanelDefinition)Mockito.verify((Object)panel)).removePart(part);
        ((PartDefinition)Mockito.verify((Object)part)).setPlace((PlaceRequest)Matchers.any(ConditionalPlaceRequest.class));
    }

    private Collection<SyncBeanDef<ExperimentalActivityReference>> getReferences() {
        return Arrays.asList(this.createReference(new TestExperimentalActivityReference(ACTIVITY_1_ID_TYPENAME, ACTIVITY_1_ID, FEATURE_1_ID, ActivityResourceType.PERSPECTIVE)), this.createReference(new TestExperimentalActivityReference(ACTIVITY_2_ID_TYPENAME, ACTIVITY_2_ID, FEATURE_2_ID, ActivityResourceType.SCREEN)));
    }

    private SyncBeanDef<ExperimentalActivityReference> createReference(ExperimentalActivityReference activityReference) {
        SyncBeanDef def = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)def.getInstance()).thenReturn((Object)activityReference);
        Mockito.when((Object)def.newInstance()).thenReturn((Object)activityReference);
        return def;
    }
}

