/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.disabled.component;

import elemental2.dom.HTMLElement;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.experimental.client.disabled.component.DisabledFeatureComponentView;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;

@Dependent
public class DisabledFeatureComponent
implements IsElement {
    private DisabledFeatureComponentView view;
    private ExperimentalFeatureDefRegistry defRegistry;
    private TranslationService translationService;

    @Inject
    public DisabledFeatureComponent(DisabledFeatureComponentView view, ExperimentalFeatureDefRegistry defRegistry, TranslationService translationService) {
        this.view = view;
        this.defRegistry = defRegistry;
        this.translationService = translationService;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void show(String featureId) {
        ExperimentalFeatureDefinition feature = this.defRegistry.getFeatureById(featureId);
        PortablePreconditions.checkNotNull((String)"experimentalFeature", (Object)feature);
        String featureName = Optional.ofNullable(this.translationService.getTranslation(feature.getNameKey())).orElse(featureId);
        String text = feature.isGlobal() ? this.translationService.format("DisabledGlobalExperimentalFeature", new Object[]{featureName}) : this.translationService.format("DisabledExperimentalFeature", new Object[]{featureName});
        this.view.show(text);
    }
}

