/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.client.editor.ExperimentalFeaturesEditorScreen;
import org.uberfire.experimental.client.editor.ExperimentalFeaturesEditorScreenView;
import org.uberfire.experimental.client.editor.group.ExperimentalFeaturesGroup;
import org.uberfire.experimental.client.editor.group.ExperimentalFeaturesGroupView;
import org.uberfire.experimental.client.editor.group.TestExperimentalFeaturesGroup;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditor;
import org.uberfire.experimental.client.service.ClientExperimentalFeaturesRegistryService;
import org.uberfire.experimental.client.test.TestExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.experimental.service.editor.FeaturesEditorService;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeaturesRegistryImpl;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class ExperimentalFeaturesEditorScreenTest {
    private static final String USER_NAME = "user";
    @Mock
    private ManagedInstance<ExperimentalFeatureEditor> editorInstance;
    @Mock
    private TranslationService translationService;
    @Mock
    private ClientExperimentalFeaturesRegistryService registryService;
    private ExperimentalFeatureDefRegistry defRegistry;
    private ExperimentalFeaturesRegistryImpl registry;
    private List<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>();
    @Mock
    private ExperimentalFeaturesEditorScreenView view;
    @Mock
    private ManagedInstance<ExperimentalFeaturesGroup> instance;
    @Mock
    private FeaturesEditorService featuresEditorService;
    @Mock
    private AuthorizationManager authorizationManager;
    private SessionInfoMock sessionInfo;
    private CallerMock<FeaturesEditorService> editorServiceCaller;
    private ExperimentalFeaturesEditorScreen presenter;
    private List<TestExperimentalFeaturesGroup> groups = new ArrayList<TestExperimentalFeaturesGroup>();

    @Before
    public void init() {
        Mockito.when((Object)this.editorInstance.get()).thenReturn(Mockito.mock(ExperimentalFeatureEditor.class));
        this.sessionInfo = new SessionInfoMock(USER_NAME);
        this.defRegistry = new TestExperimentalFeatureDefRegistry();
        this.features = this.defRegistry.getAllFeatures().stream().map(def -> new ExperimentalFeatureImpl(def.getId(), false)).collect(Collectors.toList());
        this.registry = new ExperimentalFeaturesRegistryImpl(this.features);
        Mockito.when((Object)this.registryService.getFeaturesRegistry()).thenReturn((Object)this.registry);
        Mockito.when((Object)this.instance.get()).thenAnswer(invocationOnMock -> this.createGroup());
        this.editorServiceCaller = new CallerMock((Object)this.featuresEditorService);
        this.presenter = new ExperimentalFeaturesEditorScreen(this.translationService, this.registryService, this.defRegistry, this.view, this.instance, this.editorServiceCaller, (SessionInfo)this.sessionInfo, this.authorizationManager);
    }

    @Test
    public void testBasicFunctions() {
        this.presenter.init();
        ((ExperimentalFeaturesEditorScreenView)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        this.presenter.getTitle();
        ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation("ExperimentalFeaturesEditorScreenViewImpl.experimentalFeaturesTitle");
        this.presenter.clear();
        this.verifyClear();
        Assert.assertSame((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testShowGroupsWithPermissions() {
        this.testShowGroups(true);
    }

    @Test
    public void testShowGroupsWithoutPermissions() {
        this.testShowGroups(false);
    }

    private void testShowGroups(boolean withPermissions) {
        Mockito.when((Object)this.authorizationManager.authorize((ResourceType)Matchers.any(ResourceType.class), (ResourceAction)Matchers.any(ResourceAction.class), (User)Matchers.any(User.class))).thenReturn((Object)withPermissions);
        this.presenter.show();
        this.verifyClear();
        int expectedGroups = 2;
        ArrayList<String> expectedGroupNames = new ArrayList<String>();
        expectedGroupNames.add("experimentalFeatures.generalGroup");
        expectedGroupNames.add("group");
        if (withPermissions) {
            ++expectedGroups;
            expectedGroupNames.add("experimentalFeatures.globalGroup");
        }
        ((ManagedInstance)Mockito.verify(this.instance, (VerificationMode)Mockito.times((int)expectedGroups))).get();
        Map<String, TestExperimentalFeaturesGroup> groupMap = this.groups.stream().collect(Collectors.toMap(TestExperimentalFeaturesGroup::getLabelKey, group -> group));
        MapAssert mapAssert = Assertions.assertThat(groupMap);
        ((MapAssert)mapAssert.hasSize(expectedGroups)).containsKeys((Object[])expectedGroupNames.toArray(new String[expectedGroups]));
    }

    @Test
    public void testModificationCallback() {
        EditableExperimentalFeature feature = new EditableExperimentalFeature("feature_1", true);
        this.presenter.doSave(feature);
        ((FeaturesEditorService)Mockito.verify((Object)this.featuresEditorService)).save(feature);
        ((ClientExperimentalFeaturesRegistryService)Mockito.verify((Object)this.registryService)).updateExperimentalFeature(feature.getFeatureId(), feature.isEnabled());
    }

    private ExperimentalFeaturesGroup createGroup() {
        TestExperimentalFeaturesGroup group = new TestExperimentalFeaturesGroup((ExperimentalFeaturesGroupView)Mockito.mock(ExperimentalFeaturesGroupView.class), (TranslationService)Mockito.mock(TranslationService.class), this.editorInstance);
        this.groups.add(group);
        return group;
    }

    private void verifyClear() {
        ((ExperimentalFeaturesEditorScreenView)Mockito.verify((Object)this.view)).clear();
        ((ManagedInstance)Mockito.verify(this.instance)).destroyAll();
    }
}

