/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.editor.group;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Document;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLLabelElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.experimental.client.editor.group.ExperimentalFeaturesGroupView;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditor;
import org.uberfire.experimental.client.util.ExperimentalUtils;

@Templated
public class ExperimentalFeaturesGroupViewImpl
implements ExperimentalFeaturesGroupView,
IsElement {
    @Inject
    @DataField
    private HTMLDivElement panel;
    @Inject
    @Named(value="span")
    @DataField
    private HTMLElement caret;
    @Inject
    @DataField
    private HTMLLabelElement header;
    @Inject
    @DataField
    private HTMLUListElement featuresContainer;
    @Inject
    @DataField
    private HTMLAnchorElement enableAll;
    @Inject
    private Elemental2DomUtil util;
    @Inject
    private Document document;
    private ExperimentalFeaturesGroupView.Presenter presenter;

    @PostConstruct
    public void init() {
        String id = ExperimentalUtils.createUniqueId();
        this.header.setAttribute("data-target", "#" + id);
        this.panel.setAttribute("id", id);
    }

    @Override
    public void setLabel(String label) {
        this.header.textContent = label;
    }

    @Override
    public void setEnableAllLabel(String label) {
        this.enableAll.textContent = label;
    }

    @Override
    public void render(ExperimentalFeatureEditor editor) {
        HTMLLIElement li = (HTMLLIElement)this.document.createElement("li");
        li.setAttribute("class", "list-group-item");
        li.appendChild((Node)editor.getElement());
        this.featuresContainer.appendChild((Node)li);
    }

    @Override
    public void clear() {
        this.util.removeAllElementChildren((Node)this.header);
        this.util.removeAllElementChildren((Node)this.featuresContainer);
        this.collapse();
    }

    @Override
    public void expand() {
        this.header.classList.remove(new String[]{"collapsed"});
        this.header.setAttribute("aria-expanded", "true");
        this.panel.classList.add(new String[]{"in"});
        this.panel.setAttribute("aria-expanded", "true");
        this.arrangeCaret();
    }

    @Override
    public void collapse() {
        this.header.classList.add(new String[]{"collapsed"});
        this.header.setAttribute("aria-expanded", "false");
        this.panel.classList.remove(new String[]{"in"});
        this.panel.setAttribute("aria-expanded", "false");
        this.arrangeCaret();
    }

    @Override
    public void arrangeCaret() {
        this.caret.className = this.presenter.isExpanded() ? "fa fa-caret-down" : "fa fa-caret-right";
    }

    public void init(ExperimentalFeaturesGroupView.Presenter presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"enableAll"})
    public void onEnableAll(ClickEvent clickEvent) {
        this.presenter.doEnableAll();
        this.enableAll.blur();
    }

    @EventHandler(value={"header"})
    public void onExpand(ClickEvent clickEvent) {
        this.presenter.notifyExpand();
    }
}

