/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.editor.group.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditor;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditorView;
import org.uberfire.experimental.client.test.TestExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class ExperimentalFeatureEditorTest {
    private TestExperimentalFeatureDefRegistry defRegistry;
    @Mock
    private ExperimentalFeatureEditorView view;
    @Mock
    private TranslationService translationService;
    @Mock
    private ParameterizedCommand<EditableExperimentalFeature> onChange;
    private ExperimentalFeatureEditor editor;

    @Before
    public void init() {
        this.defRegistry = new TestExperimentalFeatureDefRegistry();
        this.editor = new ExperimentalFeatureEditor((ExperimentalFeatureDefRegistry)this.defRegistry, this.translationService, this.view);
    }

    @Test
    public void testBasicFunctionallity() {
        this.editor.init();
        ((ExperimentalFeatureEditorView)Mockito.verify((Object)this.view)).init((Object)this.editor);
        this.editor.getElement();
        ((ExperimentalFeatureEditorView)Mockito.verify((Object)this.view)).getElement();
        EditableExperimentalFeature feature = (EditableExperimentalFeature)Mockito.spy((Object)new EditableExperimentalFeature("feature_1", false));
        this.editor.render(feature, this.onChange);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)2))).getTranslation("feature_1");
        ((ExperimentalFeatureEditorView)Mockito.verify((Object)this.view)).render((String)ArgumentMatchers.eq((Object)"feature_1"), (String)ArgumentMatchers.eq(null), ArgumentMatchers.eq((boolean)false));
        Assert.assertSame((Object)feature, (Object)this.editor.getFeature());
        Assert.assertEquals((Object)"feature_1", (Object)this.editor.getName());
        this.editor.notifyChange(false);
        ((EditableExperimentalFeature)Mockito.verify((Object)feature, (VerificationMode)Mockito.never())).setEnabled(false);
        ((ParameterizedCommand)Mockito.verify(this.onChange, (VerificationMode)Mockito.never())).execute(ArgumentMatchers.any());
        this.editor.notifyChange(true);
        ((ParameterizedCommand)Mockito.verify(this.onChange)).execute(ArgumentMatchers.any());
        ((EditableExperimentalFeature)Mockito.verify((Object)feature)).setEnabled(true);
        ((ParameterizedCommand)Mockito.verify(this.onChange)).execute(ArgumentMatchers.any());
        this.editor.notifyChange(false);
        ((ParameterizedCommand)Mockito.verify(this.onChange, (VerificationMode)Mockito.times((int)2))).execute(ArgumentMatchers.any());
        ((EditableExperimentalFeature)Mockito.verify((Object)feature)).setEnabled(false);
        ((ParameterizedCommand)Mockito.verify(this.onChange, (VerificationMode)Mockito.times((int)2))).execute(ArgumentMatchers.any());
        Assert.assertFalse((boolean)this.editor.isEnabled());
        ((EditableExperimentalFeature)Mockito.verify((Object)feature, (VerificationMode)Mockito.times((int)5))).isEnabled();
        this.editor.enable();
        ((EditableExperimentalFeature)Mockito.verify((Object)feature, (VerificationMode)Mockito.times((int)6))).isEnabled();
        ((ExperimentalFeatureEditorView)Mockito.verify((Object)this.view)).setEnabled(true);
    }

    @Test
    public void testCompareTo() {
        new ArrayList();
        ExperimentalFeatureEditor editor4 = new ExperimentalFeatureEditor((ExperimentalFeatureDefRegistry)this.defRegistry, this.translationService, (ExperimentalFeatureEditorView)Mockito.mock(ExperimentalFeatureEditorView.class));
        ExperimentalFeatureImpl feature3 = new ExperimentalFeatureImpl("feature_3", false);
        ExperimentalFeatureEditor editor3 = new ExperimentalFeatureEditor((ExperimentalFeatureDefRegistry)this.defRegistry, this.translationService, (ExperimentalFeatureEditorView)Mockito.mock(ExperimentalFeatureEditorView.class));
        editor3.render(new EditableExperimentalFeature((ExperimentalFeature)feature3), (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class));
        ExperimentalFeatureImpl feature1 = new ExperimentalFeatureImpl("feature_1", false);
        ExperimentalFeatureEditor editor1 = new ExperimentalFeatureEditor((ExperimentalFeatureDefRegistry)this.defRegistry, this.translationService, (ExperimentalFeatureEditorView)Mockito.mock(ExperimentalFeatureEditorView.class));
        editor1.render(new EditableExperimentalFeature((ExperimentalFeature)feature1), (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class));
        ExperimentalFeatureEditor editor5 = new ExperimentalFeatureEditor((ExperimentalFeatureDefRegistry)this.defRegistry, this.translationService, (ExperimentalFeatureEditorView)Mockito.mock(ExperimentalFeatureEditorView.class));
        ExperimentalFeatureImpl feature2 = new ExperimentalFeatureImpl("feature_2", false);
        ExperimentalFeatureEditor editor2 = new ExperimentalFeatureEditor((ExperimentalFeatureDefRegistry)this.defRegistry, this.translationService, (ExperimentalFeatureEditorView)Mockito.mock(ExperimentalFeatureEditorView.class));
        editor2.render(new EditableExperimentalFeature((ExperimentalFeature)feature2), (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class));
        List<ExperimentalFeatureEditor> editors = Arrays.asList(editor1, editor2, editor3, editor4, editor5);
        List sortedEditors = editors.stream().sorted().collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(sortedEditors).hasSize(editors.size())).containsExactly((Object[])new ExperimentalFeatureEditor[]{editor4, editor5, editor1, editor2, editor3});
    }
}

