/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.service.impl;

import java.util.ArrayList;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.client.service.impl.ClientExperimentalFeaturesRegistryServiceImpl;
import org.uberfire.experimental.service.backend.BackendExperimentalFeaturesRegistryService;
import org.uberfire.experimental.service.backend.impl.ExperimentalFeaturesSessionImpl;
import org.uberfire.experimental.service.events.NonPortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.events.PortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeaturesRegistryImpl;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientExperimentalFeaturesRegistryServiceImplTest {
    private static final String WRONG_FEATURE_ID = "this feature shouldn't exist";
    @Mock
    private BackendExperimentalFeaturesRegistryService backendService;
    @Mock
    private Event<NonPortableExperimentalFeatureModifiedEvent> event;
    private CallerMock<BackendExperimentalFeaturesRegistryService> callerMock;
    private ExperimentalFeaturesRegistryImpl registry;
    private ClientExperimentalFeaturesRegistryServiceImpl service;

    @Before
    public void init() {
        this.callerMock = new CallerMock((Object)this.backendService);
        this.service = new ClientExperimentalFeaturesRegistryServiceImpl(this.callerMock, this.event);
    }

    @Test
    public void tesBasicTestExperimentalEnabled() {
        this.doBasicTest(true);
    }

    @Test
    public void tesBasicTestExperimentalDisabled() {
        this.doBasicTest(false);
    }

    @Test
    public void testNotifyFeatureUpdate() {
        this.initService(true);
        ExperimentalFeatureImpl feature = new ExperimentalFeatureImpl("feature_1", false);
        this.service.updateExperimentalFeature(feature.getFeatureId(), feature.isEnabled());
        this.checkNotifyFeatureUpdate(feature);
    }

    @Test
    public void testNotifyFeatureUpdateViaEvent() {
        this.initService(true);
        ExperimentalFeatureImpl feature = new ExperimentalFeatureImpl("feature_1", false);
        this.service.onGlobalFeatureModified(new PortableExperimentalFeatureModifiedEvent((ExperimentalFeature)feature));
        this.checkNotifyFeatureUpdate(feature);
    }

    private void checkNotifyFeatureUpdate(ExperimentalFeatureImpl feature) {
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(NonPortableExperimentalFeatureModifiedEvent.class);
        ((Event)Mockito.verify(this.event)).fire((Object)((NonPortableExperimentalFeatureModifiedEvent)eventCaptor.capture()));
        Assert.assertEquals((Object)feature, (Object)((NonPortableExperimentalFeatureModifiedEvent)eventCaptor.getValue()).getFeature());
    }

    @Test
    public void testWrongNotifyFeatureUpdate() {
        this.initService(true);
        ExperimentalFeatureImpl feature = new ExperimentalFeatureImpl("feature_1", true);
        this.service.updateExperimentalFeature(feature.getFeatureId(), feature.isEnabled());
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire((Object)((NonPortableExperimentalFeatureModifiedEvent)ArgumentMatchers.any()));
        feature = new ExperimentalFeatureImpl(WRONG_FEATURE_ID, true);
        this.service.updateExperimentalFeature(feature.getFeatureId(), feature.isEnabled());
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire((Object)((NonPortableExperimentalFeatureModifiedEvent)ArgumentMatchers.any()));
    }

    @Test
    public void testWrongNotifyFeatureUpdateViaEvent() {
        this.initService(true);
        ExperimentalFeatureImpl feature = new ExperimentalFeatureImpl("feature_1", true);
        this.service.onGlobalFeatureModified(new PortableExperimentalFeatureModifiedEvent((ExperimentalFeature)feature));
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire((Object)((NonPortableExperimentalFeatureModifiedEvent)ArgumentMatchers.any()));
        feature = new ExperimentalFeatureImpl(WRONG_FEATURE_ID, true);
        this.service.onGlobalFeatureModified(new PortableExperimentalFeatureModifiedEvent((ExperimentalFeature)feature));
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire((Object)((NonPortableExperimentalFeatureModifiedEvent)ArgumentMatchers.any()));
    }

    @Test
    public void testNotifyFeatureUpdateWhenExperimentalDisabled() {
        this.initService(false);
        ExperimentalFeatureImpl feature = new ExperimentalFeatureImpl("feature_1", false);
        this.service.updateExperimentalFeature(feature.getFeatureId(), feature.isEnabled());
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire((Object)((NonPortableExperimentalFeatureModifiedEvent)ArgumentMatchers.any()));
    }

    @Test
    public void testNotifyFeatureUpdateWhenExperimentalDisabledViaEvent() {
        this.initService(false);
        ExperimentalFeatureImpl feature = new ExperimentalFeatureImpl("feature_1", false);
        this.service.onGlobalFeatureModified(new PortableExperimentalFeatureModifiedEvent((ExperimentalFeature)feature));
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire((Object)((NonPortableExperimentalFeatureModifiedEvent)ArgumentMatchers.any()));
    }

    private void doBasicTest(boolean experimentalEnabled) {
        this.initService(experimentalEnabled);
        Assert.assertEquals((Object)experimentalEnabled, (Object)this.service.isExperimentalEnabled());
        Assert.assertEquals((Object)experimentalEnabled, (Object)this.service.isFeatureEnabled("feature_1"));
        Assert.assertEquals((Object)experimentalEnabled, (Object)this.service.isFeatureEnabled("feature_2"));
        Assert.assertFalse((boolean)this.service.isFeatureEnabled("feature_3"));
        Assert.assertTrue((boolean)this.service.isFeatureEnabled(WRONG_FEATURE_ID));
        Assert.assertEquals((Object)this.registry, (Object)this.service.getFeaturesRegistry());
    }

    private void initService(boolean experimentalEnabled) {
        ArrayList<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>();
        features.add(new ExperimentalFeatureImpl("feature_1", true));
        features.add(new ExperimentalFeatureImpl("feature_2", true));
        features.add(new ExperimentalFeatureImpl("feature_3", false));
        this.registry = (ExperimentalFeaturesRegistryImpl)Mockito.spy((Object)new ExperimentalFeaturesRegistryImpl(features));
        Mockito.when((Object)this.backendService.getExperimentalFeaturesSession()).thenReturn((Object)new ExperimentalFeaturesSessionImpl(experimentalEnabled, this.registry));
        this.service.loadRegistry();
    }
}

