/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.client.editor.group;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.client.editor.group.ExperimentalFeaturesGroup;
import org.uberfire.experimental.client.editor.group.ExperimentalFeaturesGroupView;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditor;
import org.uberfire.experimental.client.editor.group.feature.ExperimentalFeatureEditorView;
import org.uberfire.experimental.client.test.TestExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.editor.EditableExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class ExperimentalFeaturesGroupTest {
    private static final String GROUP_KEY = "group";
    private static final String ANOTHER_GROUP_KEY = "group2";
    @Mock
    private ExperimentalFeaturesGroupView view;
    @Mock
    private TranslationService translationService;
    @Mock
    private ManagedInstance<ExperimentalFeatureEditor> editorInstance;
    @Mock
    private ParameterizedCommand<EditableExperimentalFeature> callback;
    private TestExperimentalFeatureDefRegistry defRegistry;
    private List<ExperimentalFeatureImpl> features;
    private List<ExperimentalFeatureEditor> editors;
    private ExperimentalFeaturesGroup group;

    @Before
    public void init() {
        this.defRegistry = new TestExperimentalFeatureDefRegistry();
        this.features = this.defRegistry.getUserFeatures().stream().map(definition -> new ExperimentalFeatureImpl(definition.getId(), false)).collect(Collectors.toList());
        this.editors = new ArrayList<ExperimentalFeatureEditor>();
        Mockito.when((Object)((ExperimentalFeatureEditor)this.editorInstance.get())).then(invocationOnMock -> {
            ExperimentalFeatureEditorView editorView = (ExperimentalFeatureEditorView)Mockito.mock(ExperimentalFeatureEditorView.class);
            ExperimentalFeatureEditor editor = (ExperimentalFeatureEditor)Mockito.spy((Object)new ExperimentalFeatureEditor((ExperimentalFeatureDefRegistry)this.defRegistry, this.translationService, editorView));
            ((ExperimentalFeatureEditorView)Mockito.doAnswer(invocationOnMock1 -> {
                Boolean enabled = (Boolean)invocationOnMock1.getArguments()[0];
                editor.notifyChange(enabled.booleanValue());
                return null;
            }).when((Object)editorView)).setEnabled(ArgumentMatchers.anyBoolean());
            this.editors.add(editor);
            return editor;
        });
        this.group = new ExperimentalFeaturesGroup(this.view, this.translationService, this.editorInstance);
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view)).init((Object)this.group);
        this.group.getElement();
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view)).getElement();
    }

    @Test
    public void testLoadWithEnableAllAnchor() {
        this.testLoad(true);
    }

    @Test
    public void testLoadWithDisableAllAnchor() {
        this.testLoad(false);
    }

    @Test
    public void testPressEnableAll() {
        this.testLoad(true);
        this.testAnchorPress(false);
    }

    @Test
    public void testPressDisableAll() {
        this.testLoad(false);
        this.testAnchorPress(true);
    }

    @Test
    public void testExpandAndCollapse() {
        Assert.assertFalse((boolean)this.group.isExpanded());
        this.group.collapse();
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).collapse();
        this.group.expand();
        Assert.assertTrue((boolean)this.group.isExpanded());
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view)).expand();
        this.group.expand();
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view)).expand();
        this.group.collapse();
        Assert.assertFalse((boolean)this.group.isExpanded());
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view)).collapse();
        this.group.notifyExpand();
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view)).arrangeCaret();
    }

    @Test
    public void testGroupsSorting() {
        ExperimentalFeaturesGroup generalGroup = new ExperimentalFeaturesGroup(this.view, this.translationService, this.editorInstance);
        generalGroup.init("experimentalFeatures.generalGroup", new ArrayList(), this.callback);
        ExperimentalFeaturesGroup secondGroup = new ExperimentalFeaturesGroup(this.view, this.translationService, this.editorInstance);
        secondGroup.init(GROUP_KEY, new ArrayList(), this.callback);
        ExperimentalFeaturesGroup thirdGroup = new ExperimentalFeaturesGroup(this.view, this.translationService, this.editorInstance);
        thirdGroup.init(ANOTHER_GROUP_KEY, new ArrayList(), this.callback);
        ExperimentalFeaturesGroup adminGroup = new ExperimentalFeaturesGroup(this.view, this.translationService, this.editorInstance);
        adminGroup.init("experimentalFeatures.globalGroup", new ArrayList(), this.callback);
        TreeSet<ExperimentalFeaturesGroup> groups = new TreeSet<ExperimentalFeaturesGroup>();
        groups.add(secondGroup);
        groups.add(adminGroup);
        groups.add(generalGroup);
        groups.add(thirdGroup);
        ((IterableAssert)Assertions.assertThat(groups).hasSize(4)).containsExactly((Object[])new ExperimentalFeaturesGroup[]{generalGroup, secondGroup, thirdGroup, adminGroup});
    }

    private void testAnchorPress(boolean enabled) {
        this.group.doEnableAll();
        this.editors.forEach(editor -> ((ExperimentalFeatureEditor)Mockito.verify((Object)editor)).enable());
        ((ParameterizedCommand)Mockito.verify(this.callback, (VerificationMode)Mockito.times((int)3))).execute((Object)((EditableExperimentalFeature)ArgumentMatchers.any()));
        this.checkSetEnableAllLabel(enabled, 2);
    }

    private void testLoad(boolean enableAll) {
        if (!enableAll) {
            this.features.forEach(feature -> feature.setEnabled(true));
        }
        this.group.init(GROUP_KEY, new ArrayList<ExperimentalFeatureImpl>(this.features), this.callback);
        this.checkClear();
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view)).setLabel(GROUP_KEY);
        this.checkSetEnableAllLabel(enableAll, 1);
    }

    private void checkSetEnableAllLabel(boolean isEnabled, int times) {
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)times))).setEnableAllLabel((String)ArgumentMatchers.any());
        if (isEnabled) {
            ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation("ExperimentalFeaturesGroup.enableAll");
        } else {
            ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation("ExperimentalFeaturesGroup.disableAll");
        }
    }

    @Test
    public void testClear() {
        this.group.clear();
        this.checkClear();
    }

    private void checkClear() {
        ((ExperimentalFeaturesGroupView)Mockito.verify((Object)this.view)).clear();
        ((ManagedInstance)Mockito.verify(this.editorInstance)).destroyAll();
    }
}

