/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.attribute;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Test;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class DublinCoreTest {
    protected static final List<File> tempFiles = new ArrayList<File>();
    protected static IOService ioService = null;

    @Test
    public void testDCore() throws IOException {
        Path dir = this.ioService().get(DublinCoreTest.createTempDirectory().toURI());
        final Path file = dir.resolve("myFile.txt");
        this.ioService().write(file, "mycontent", Collections.emptySet(), new FileAttribute[0]);
        DublinCoreView view = (DublinCoreView)this.ioService().getFileAttributeView(file, DublinCoreView.class);
        Assert.assertNotNull((Object)view);
        Assert.assertNotNull((Object)view.readAttributes());
        Assert.assertNotNull((Object)view.readAttributes().languages());
        Assert.assertEquals((int)0, (int)view.readAttributes().languages().size());
        this.ioService().write(file, "mycontent", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.creator";
            }

            public Object value() {
                return "some user name here";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.language[0]";
            }

            public Object value() {
                return "en";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.language[1]";
            }

            public Object value() {
                return "pt-BR";
            }
        }});
        view = (DublinCoreView)this.ioService().getFileAttributeView(file, DublinCoreView.class);
        Assert.assertNotNull((Object)view);
        Assert.assertNotNull((Object)view.readAttributes());
        Assert.assertNotNull((Object)view.readAttributes().languages());
        Assert.assertEquals((int)2, (int)view.readAttributes().languages().size());
        Assert.assertTrue((boolean)view.readAttributes().languages().contains("pt-BR"));
        Assert.assertTrue((boolean)view.readAttributes().languages().contains("en"));
        Assert.assertEquals((int)1, (int)view.readAttributes().creators().size());
        Assert.assertTrue((boolean)view.readAttributes().creators().contains("some user name here"));
        this.ioService().setAttributes(file, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.identifier";
            }

            public Object value() {
                return file.toUri().toString();
            }
        }});
        view = (DublinCoreView)this.ioService().getFileAttributeView(file, DublinCoreView.class);
        Assert.assertNotNull((Object)view);
        Assert.assertNotNull((Object)view.readAttributes());
        Assert.assertNotNull((Object)view.readAttributes().languages());
        Assert.assertEquals((int)2, (int)view.readAttributes().languages().size());
        Assert.assertTrue((boolean)view.readAttributes().languages().contains("pt-BR"));
        Assert.assertTrue((boolean)view.readAttributes().languages().contains("en"));
        Assert.assertEquals((int)1, (int)view.readAttributes().creators().size());
        Assert.assertTrue((boolean)view.readAttributes().creators().contains("some user name here"));
        Assert.assertEquals((int)1, (int)view.readAttributes().identifiers().size());
        Assert.assertTrue((boolean)view.readAttributes().identifiers().contains(file.toUri().toString()));
    }

    public IOService ioService() {
        if (ioService == null) {
            ioService = new IOServiceDotFileImpl();
        }
        return ioService;
    }

    @AfterClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }
}

