/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.io.CommonIOServiceDotFileTest;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class OpenCloseTest {
    final IOService ioService = new IOServiceDotFileImpl();
    private static File path = null;

    @Before
    public void setup() throws IOException {
        path = CommonIOServiceDotFileTest.createTempDirectory();
        System.setProperty("org.uberfire.nio.git.dir", path.getAbsolutePath());
        System.out.println(".niogit: " + path.getAbsolutePath());
        URI newRepo = URI.create("git://open-close-repo-test");
        this.ioService.newFileSystem(newRepo, new HashMap());
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        if (path != null) {
            FileUtils.deleteQuietly((File)path);
        }
    }

    @Test
    public void testOpenCloseFS() throws IOException, InterruptedException {
        Path init = this.ioService.get(URI.create("git://open-close-repo-test/readme.txt"));
        this.ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        this.ioService.delete(init.getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
        URI repo = URI.create("git://open-close-repo-test");
        try {
            this.ioService.newFileSystem(repo, new HashMap());
        }
        catch (FileSystemAlreadyExistsException ex) {
            Assert.fail((String)"FS doesn't exists!");
        }
        this.ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        Assert.assertEquals((Object)"init!", (Object)this.ioService.readAllString(init));
        init = this.ioService.get(URI.create("git://open-close-repo-test/readme.txt"));
        this.ioService.delete(init.getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
    }
}

