/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.lock.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.uberfire.io.CommonIOServiceDotFileTest;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.io.lock.FSLockService;
import org.uberfire.io.lock.impl.FSLockServiceImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class FSLockServiceImplTest {
    static final IOService ioService = new IOServiceDotFileImpl();
    static FileSystem fs1;
    static FileSystem fs2;
    FSLockServiceImpl lockService = new FSLockServiceImpl();
    private static File path;

    @BeforeClass
    public static void setup() throws IOException {
        path = CommonIOServiceDotFileTest.createTempDirectory();
        System.setProperty("org.uberfire.nio.git.dir", path.getAbsolutePath());
        System.out.println(".niogit: " + path.getAbsolutePath());
        URI newRepo = URI.create("git://fs-lock-repo");
        fs1 = ioService.newFileSystem(newRepo, new HashMap());
        Path init = ioService.get(URI.create("git://fs-lock-repo/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
        URI newRepo2 = URI.create("git://fs-lock-repo-another-test");
        fs2 = ioService.newFileSystem(newRepo2, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        init = ioService.get(URI.create("git://fs-lock-repo/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        if (path != null) {
            FileUtils.deleteQuietly((File)path);
        }
    }

    @Test
    public void acquireLock() throws Exception {
        Assert.assertFalse((boolean)this.lockService.isLocked(fs1));
        this.lockService.lock(fs1);
        Assert.assertTrue((boolean)this.lockService.isLocked(fs1));
        this.lockService.unlock(fs1);
        Assert.assertFalse((boolean)this.lockService.isLocked(fs1));
    }

    @Test
    public void acquireTwoLock() throws Exception {
        Assert.assertFalse((boolean)this.lockService.isLocked(fs1));
        Assert.assertFalse((boolean)this.lockService.isLocked(fs2));
        this.lockService.lock(fs1);
        Assert.assertTrue((boolean)this.lockService.isLocked(fs1));
        Assert.assertFalse((boolean)this.lockService.isLocked(fs2));
        this.lockService.lock(fs2);
        Assert.assertTrue((boolean)this.lockService.isLocked(fs1));
        Assert.assertTrue((boolean)this.lockService.isLocked(fs2));
        this.lockService.unlock(fs2);
        Assert.assertFalse((boolean)this.lockService.isLocked(fs2));
        Assert.assertTrue((boolean)this.lockService.isLocked(fs1));
        this.lockService.unlock(fs1);
        Assert.assertFalse((boolean)this.lockService.isLocked(fs1));
        Assert.assertFalse((boolean)this.lockService.isLocked(fs1));
    }

    @Ignore
    @Test
    public void threeThreadsTryingToAcquireLockForTheSameFS() throws Exception {
        FSThread fsThread1 = new FSThread(fs1, (FSLockService)this.lockService);
        Thread t1 = new Thread(fsThread1);
        FSThread fsThread2 = new FSThread(fs1, (FSLockService)this.lockService);
        Thread t2 = new Thread(fsThread2);
        FSThread fsThread3 = new FSThread(fs1, (FSLockService)this.lockService);
        Thread t3 = new Thread(fsThread3);
        t1.start();
        t2.start();
        t3.start();
        t1.join();
        t2.join();
        t3.join();
        Assert.assertTrue((fsThread1.whenITookLock() < fsThread2.whenITookLock() ? 1 : 0) != 0);
        Assert.assertTrue((fsThread2.whenITookLock() < fsThread3.whenITookLock() ? 1 : 0) != 0);
        this.assertMinDeltas(fsThread1, fsThread2, fsThread3);
    }

    @Test
    public void sameThreadShouldNotWaitForLock() {
        this.lockService.lock(fs1);
        this.lockService.waitForUnlock(fs1);
    }

    private void assertMinDeltas(FSThread fsThread1, FSThread fsThread2, FSThread fsThread3) {
        Assert.assertTrue((fsThread2.whenITookLock() - fsThread1.whenITookLock() >= (long)fsThread1.waitTime() ? 1 : 0) != 0);
        Assert.assertTrue((fsThread3.whenITookLock() - fsThread2.whenITookLock() >= (long)fsThread1.waitTime() ? 1 : 0) != 0);
    }

    static {
        path = null;
    }

    class FSThread
    implements Runnable {
        private final FileSystem fs;
        private final FSLockService lockService;
        private Date timestampThatITakeTheLock;

        public FSThread(FileSystem fs, FSLockService lockService) {
            this.fs = fs;
            this.lockService = lockService;
        }

        @Override
        public void run() {
            try {
                this.lockService.lock(this.fs);
                this.timestampThatITakeTheLock = new Date();
                Thread.sleep(this.waitTime());
                this.lockService.unlock(this.fs);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        int waitTime() {
            return 100;
        }

        long whenITookLock() {
            return this.timestampThatITakeTheLock.getTime();
        }
    }
}

