/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.io.CommonIOServiceDotFileTest;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

public class BatchTest {
    static final IOService ioService = new IOServiceDotFileImpl();
    private static File path = null;
    static FileSystem fs1;
    static JGitFileSystem fs1Batch;
    static FileSystem fs2;
    static JGitFileSystem fs2Batch;
    static FileSystem fs3;
    static JGitFileSystem fs3Batch;

    @BeforeClass
    public static void setup() throws IOException {
        path = CommonIOServiceDotFileTest.createTempDirectory();
        System.setProperty("org.uberfire.nio.git.dir", path.getAbsolutePath());
        System.out.println(".niogit: " + path.getAbsolutePath());
        URI newRepo = URI.create("git://amend-repo-test");
        fs1 = ioService.newFileSystem(newRepo, new HashMap());
        fs1Batch = (JGitFileSystem)fs1;
        Path init = ioService.get(URI.create("git://amend-repo-test/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
        URI newRepo2 = URI.create("git://check-amend-repo-test");
        fs2 = ioService.newFileSystem(newRepo2, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        fs2Batch = (JGitFileSystem)fs2;
        init = ioService.get(URI.create("git://check-amend-repo-test/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
        URI newRepo3 = URI.create("git://check-amend-repo-test-2");
        fs3 = ioService.newFileSystem(newRepo3, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        fs3Batch = (JGitFileSystem)fs3;
        init = ioService.get(URI.create("git://check-amend-repo-test-2/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
    }

    @AfterClass
    public static void cleanup() {
        FileUtils.deleteQuietly((File)path);
        JGitFileSystemProvider gitFsProvider = (JGitFileSystemProvider)FileSystemProviders.resolveProvider((URI)URI.create("git://whatever"));
        gitFsProvider.shutdown();
        FileUtils.deleteQuietly((File)gitFsProvider.getGitRepoContainerDir());
        gitFsProvider.rescanForExistingRepositories();
    }

    @Test
    public void testBatch() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        WatchService ws = init.getFileSystem().newWatchService();
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.write(init, "init 2!", new OpenOption[]{new CommentedOption("User Tester", "message2")});
        List events = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        Path init2 = ioService.get(URI.create("git://amend-repo-test/readme2.txt"));
        ioService.write(init2, "init 3!", new OpenOption[]{new CommentedOption("User Tester", "message3")});
        List events2 = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events2.size());
        ioService.write(init2, "init 4!", new OpenOption[]{new CommentedOption("User Tester", "message4")});
        events2 = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events2.size());
        VersionAttributeView vinit = (VersionAttributeView)ioService.getFileAttributeView(init, VersionAttributeView.class);
        VersionAttributeView vinit2 = (VersionAttributeView)ioService.getFileAttributeView(init, VersionAttributeView.class);
        Assert.assertEquals((Object)"init 2!", (Object)ioService.readAllString(init));
        Assert.assertNotNull((Object)vinit);
        Assert.assertEquals((long)2L, (long)vinit.readAttributes().history().records().size());
        Assert.assertNotNull((Object)vinit2);
        Assert.assertEquals((long)2L, (long)vinit2.readAttributes().history().records().size());
        ioService.startBatch(new FileSystem[]{init.getFileSystem()});
        Path path = ioService.get(URI.create("git://amend-repo-test/mybatch" + new Random(10L).nextInt() + ".txt"));
        Path path2 = ioService.get(URI.create("git://amend-repo-test/mybatch2" + new Random(10L).nextInt() + ".txt"));
        ioService.write(path, "ooooo!", new OpenOption[0]);
        Assert.assertNotNull((Object)ws.poll());
        ioService.write(path, "ooooo wdfs fg sdf!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(path2, "ooooo222!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(path2, " sdfsdg sdg ooooo222!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch();
        List events3 = ws.poll().pollEvents();
        Assert.assertEquals((long)2L, (long)events3.size());
        VersionAttributeView v = (VersionAttributeView)ioService.getFileAttributeView(path, VersionAttributeView.class);
        VersionAttributeView v2 = (VersionAttributeView)ioService.getFileAttributeView(path2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)1L, (long)v.readAttributes().history().records().size());
        Assert.assertEquals((long)1L, (long)v2.readAttributes().history().records().size());
    }

    @Test
    public void testBatch2() throws IOException, InterruptedException {
        Path f1 = ioService.get(URI.create("git://check-amend-repo-test/f1.txt"));
        Path f2 = ioService.get(URI.create("git://check-amend-repo-test/f2.txt"));
        Path f3 = ioService.get(URI.create("git://check-amend-repo-test/f3.txt"));
        ioService.write(f1, "init f1!", new OpenOption[0]);
        ioService.write(f2, "init f2!", new OpenOption[0]);
        WatchService ws = f1.getFileSystem().newWatchService();
        ioService.startBatch(new FileSystem[]{f1.getFileSystem()});
        ioService.write(f1, "f1-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f2, "f2-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f3, "f3-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch();
        List events = ws.poll().pollEvents();
        Assert.assertEquals((long)3L, (long)events.size());
        VersionAttributeView v = (VersionAttributeView)ioService.getFileAttributeView(f1, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.readAttributes().history().records().size());
        VersionAttributeView v2 = (VersionAttributeView)ioService.getFileAttributeView(f2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)2L, (long)v2.readAttributes().history().records().size());
        VersionAttributeView v3 = (VersionAttributeView)ioService.getFileAttributeView(f3, VersionAttributeView.class);
        Assert.assertNotNull((Object)v3);
        Assert.assertEquals((long)1L, (long)v3.readAttributes().history().records().size());
        ioService.startBatch(new FileSystem[]{f1.getFileSystem()});
        ioService.write(f1, "f1-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f2, "f2-u2!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f3, "f3-u2!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch();
        events = ws.poll().pollEvents();
        Assert.assertEquals((long)2L, (long)events.size());
        v = (VersionAttributeView)ioService.getFileAttributeView(f1, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.readAttributes().history().records().size());
        v2 = (VersionAttributeView)ioService.getFileAttributeView(f2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)3L, (long)v2.readAttributes().history().records().size());
        v3 = (VersionAttributeView)ioService.getFileAttributeView(f3, VersionAttributeView.class);
        Assert.assertNotNull((Object)v3);
        Assert.assertEquals((long)2L, (long)v3.readAttributes().history().records().size());
    }

    @Test
    public void batchTest() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(new FileSystem[]{fs1});
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        Assert.assertFalse((boolean)fs1Batch.isOnBatch());
    }

    @Test
    public void justOneFSOnBatchTest() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(new FileSystem[]{fs1});
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        Assert.assertFalse((boolean)fs2Batch.isOnBatch());
        ioService.endBatch();
        Assert.assertFalse((boolean)fs1Batch.isOnBatch());
        Assert.assertFalse((boolean)fs2Batch.isOnBatch());
    }

    @Test
    public void testInnerBatch() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(new FileSystem[]{fs1});
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.startBatch(new FileSystem[]{fs1});
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        Assert.assertFalse((boolean)fs1Batch.isOnBatch());
    }

    @Test
    public void assertNumberOfCommitsOnInnerBatch() throws IOException, InterruptedException {
        Path f11 = ioService.get(URI.create("git://check-amend-repo-test/f11.txt"));
        ioService.write(f11, "init f1!", new OpenOption[0]);
        ioService.startBatch(new FileSystem[]{f11.getFileSystem()});
        ioService.write(f11, "f1-u1!", new OpenOption[0]);
        ioService.endBatch();
        VersionAttributeView v = (VersionAttributeView)ioService.getFileAttributeView(f11, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.readAttributes().history().records().size());
        ioService.startBatch(new FileSystem[]{f11.getFileSystem()});
        ioService.write(f11, "f2-u2!", new OpenOption[0]);
        ioService.startBatch(new FileSystem[]{f11.getFileSystem()});
        ioService.write(f11, "f2-u2 - inner batch!", new OpenOption[0]);
        ioService.write(f11, "f2-u2 - inner 2 batch!", new OpenOption[0]);
        ioService.endBatch();
        ioService.write(f11, "f2-u2 - inner batch! last", new OpenOption[0]);
        ioService.endBatch();
        Assert.assertEquals((Object)"f2-u2 - inner batch! last", (Object)ioService.readAllString(f11));
        v = (VersionAttributeView)ioService.getFileAttributeView(f11, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)4L, (long)v.readAttributes().history().records().size());
    }

    @Test
    public void testTwoStartedFsOnBatchByTheSameThread() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(new FileSystem[]{fs1});
        try {
            ioService.startBatch(new FileSystem[]{fs1});
        }
        catch (Exception e) {
            Assert.fail();
        }
        ioService.endBatch();
        ioService.endBatch();
        try {
            ioService.endBatch();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTwoFsOnBatchByTheSameThread() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(new FileSystem[]{fs1});
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        ioService.startBatch(new FileSystem[]{fs2});
        Assert.assertTrue((boolean)fs2Batch.isOnBatch());
        ioService.endBatch();
    }

    @Test
    public void iCanLockMultipleFS() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(new FileSystem[]{fs1, fs2});
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        Assert.assertTrue((boolean)fs2Batch.isOnBatch());
        ioService.endBatch();
        Assert.assertFalse((boolean)fs1Batch.isOnBatch());
        Assert.assertFalse((boolean)fs2Batch.isOnBatch());
    }

    @Test
    public void testDifferentThreads() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        ioService.startBatch(new FileSystem[]{fs1});
        System.out.println("After start batch");
        new Thread("second"){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    ioService.startBatch(new FileSystem[]{fs1});
                    System.out.println("Inner after batch");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        innerOut.write(("sss" + i).getBytes());
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                    System.out.println("Inner after close");
                    ioService.endBatch();
                    System.out.println("Inner after end batch");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
        ioService.endBatch();
        System.out.println("After end batch");
    }

    @Test
    public void testDifferentThreadsWithoutBatch() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        new Thread("second"){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        innerOut.write(("sss" + i).getBytes());
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
    }

    @Test
    public void testDifferentThreads3() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        ioService.startBatch(new FileSystem[]{fs1});
        System.out.println("After start batch");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    ioService.startBatch(new FileSystem[]{fs1});
                    System.out.println("Inner after batch");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        innerOut.write(("sss" + i).getBytes());
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                    System.out.println("Inner after close");
                    ioService.endBatch();
                    System.out.println("Inner after end batch");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable, "second");
        Thread thread2 = new Thread(runnable, "third");
        thread.start();
        Thread.sleep(100L);
        thread2.start();
        Thread.sleep(100L);
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
        ioService.endBatch();
        System.out.println("After end batch");
    }

    @Test
    public void testDifferentThreadsNotBatchInners() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        ioService.startBatch(new FileSystem[]{fs1});
        System.out.println("After start batch");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        innerOut.write(("sss" + i).getBytes());
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                    System.out.println("Inner after end batch");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable, "second");
        Thread thread2 = new Thread(runnable, "third");
        thread.start();
        Thread.sleep(100L);
        thread2.start();
        Thread.sleep(100L);
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
        ioService.endBatch();
        System.out.println("After end batch");
    }

    @Test
    public void testDifferentThreadsNotBatchOuter() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    ioService.startBatch(new FileSystem[]{fs1});
                    System.out.println("Inner after batch");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                    System.out.println("Inner after close");
                    ioService.endBatch();
                    System.out.println("Inner after end batch");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable, "second");
        Thread thread2 = new Thread(runnable, "third");
        thread.start();
        Thread.sleep(100L);
        thread2.start();
        Thread.sleep(100L);
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
    }
}

