/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.message.MessageType;
import org.uberfire.io.impl.cluster.ClusterMessageType;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class FileSystemSyncNonLock<V> {
    private final String serviceId;
    private final String scheme;
    private final String id;
    private final String uri;

    public FileSystemSyncNonLock(String serviceId, FileSystem fileSystem) {
        this.serviceId = serviceId;
        this.scheme = ((Path)fileSystem.getRootDirectories().iterator().next()).toUri().getScheme();
        this.id = ((FileSystemId)fileSystem).id();
        this.uri = fileSystem.toString();
    }

    public MessageType getMessageType() {
        return ClusterMessageType.SYNC_FS;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Map<String, String> buildContent() {
        return new HashMap<String, String>(){
            {
                this.put("fs_scheme", FileSystemSyncNonLock.this.scheme);
                this.put("fs_id", FileSystemSyncNonLock.this.id);
                this.put("fs_uri", FileSystemSyncNonLock.this.uri);
            }
        };
    }

    public void sendMessage(ClusterService clusterService) {
        clusterService.broadcast(this.getServiceId(), this.getMessageType(), this.buildContent());
    }

    public V execute(ClusterService clusterService, RunnableFuture<V> task) {
        try {
            task.run();
            Object result = task.get();
            this.sendMessage(clusterService);
            return result;
        }
        catch (ExecutionException e) {
            this.throwException(e.getCause());
        }
        catch (Exception e) {
            this.throwException(e);
        }
        return null;
    }

    private void throwException(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }
}

