/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl.cluster;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.uberfire.io.impl.cluster.FileSystemSyncLock;
import org.uberfire.io.impl.cluster.FileSystemSyncNonLock;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class FileSystemSyncTest {
    @Test
    public void testFileSystemToCheckProxyIssuesWithExtraInterfaces() {
        FileSystem mockedFS = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystem mockedFSId = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FileSystemId.class}));
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)mockedFS.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)mockedFSId.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)mockedFSId);
        Mockito.when((Object)rootPath.toUri()).thenReturn((Object)URI.create("jgit://myrepo"));
        Mockito.when((Object)((FileSystemId)mockedFSId).id()).thenReturn((Object)"my-fsid");
        FileSystemSyncLock fileSystemSyncLock = new FileSystemSyncLock("serviceId", mockedFS);
        Map content = fileSystemSyncLock.buildContent();
        Assert.assertEquals((Object)"my-fsid", content.get("fs_id"));
        FileSystemSyncNonLock fileSystemSyncNonLock = new FileSystemSyncNonLock("serviceId", mockedFS);
        content = fileSystemSyncNonLock.buildContent();
        Assert.assertEquals((Object)"my-fsid", content.get("fs_id"));
    }
}

