/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl.cluster;

import java.net.URI;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.io.impl.IOServiceLockable;
import org.uberfire.io.impl.cluster.IOServiceClusterImpl;
import org.uberfire.io.lock.BatchLockControl;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;

public class IOServiceClusterImplTest {
    @Test
    public void testFileSystemToCheckProxyIssuesWithExtraInterfaces() {
        FileSystem mockedFS = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystem mockedFSId = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FileSystemId.class}));
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)mockedFS.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)mockedFSId.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)mockedFSId);
        Mockito.when((Object)rootPath.toUri()).thenReturn((Object)URI.create("jgit://myrepo"));
        Mockito.when((Object)((FileSystemId)mockedFSId).id()).thenReturn((Object)"my-fsid");
        ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
        IOServiceLockable serviceLockable = (IOServiceLockable)Mockito.mock(IOServiceLockable.class);
        BatchLockControl batchLockControl = (BatchLockControl)Mockito.mock(BatchLockControl.class);
        Mockito.when((Object)serviceLockable.getFileSystems()).thenReturn(Arrays.asList(mockedFSId, mockedFS));
        Mockito.when((Object)batchLockControl.getHoldCount()).thenReturn((Object)0);
        Mockito.when((Object)serviceLockable.getLockControl()).thenReturn((Object)batchLockControl);
        TestWrapper ioServiceCluster = new TestWrapper(clusterService, serviceLockable);
        Assert.assertEquals((long)0L, (long)ioServiceCluster.batchFileSystems.size());
        ioServiceCluster.startBatch(mockedFS);
        Assert.assertEquals((long)1L, (long)ioServiceCluster.batchFileSystems.size());
        Assert.assertTrue((boolean)ioServiceCluster.batchFileSystems.contains(((FileSystemId)mockedFSId).id()));
        ioServiceCluster.endBatch();
        ((IOServiceLockable)Mockito.verify((Object)serviceLockable, (VerificationMode)Mockito.times((int)1))).endBatch();
        Assert.assertEquals((long)0L, (long)ioServiceCluster.batchFileSystems.size());
        ((ClusterService)Mockito.verify((Object)clusterService, (VerificationMode)Mockito.times((int)1))).unlock();
        ioServiceCluster = new TestWrapper(clusterService, serviceLockable);
        Assert.assertEquals((long)0L, (long)ioServiceCluster.batchFileSystems.size());
        ioServiceCluster.startBatch(new FileSystem[]{mockedFS}, new Option[]{(Option)Mockito.mock(Option.class)});
        Assert.assertEquals((long)1L, (long)ioServiceCluster.batchFileSystems.size());
        Assert.assertTrue((boolean)ioServiceCluster.batchFileSystems.contains(((FileSystemId)mockedFSId).id()));
        ioServiceCluster.endBatch();
        ((IOServiceLockable)Mockito.verify((Object)serviceLockable, (VerificationMode)Mockito.times((int)2))).endBatch();
        Assert.assertEquals((long)0L, (long)ioServiceCluster.batchFileSystems.size());
        ((ClusterService)Mockito.verify((Object)clusterService, (VerificationMode)Mockito.times((int)2))).unlock();
        ioServiceCluster = new TestWrapper(clusterService, serviceLockable);
        Assert.assertEquals((long)0L, (long)ioServiceCluster.batchFileSystems.size());
        ioServiceCluster.startBatch(mockedFS, new Option[]{(Option)Mockito.mock(Option.class)});
        Assert.assertEquals((long)1L, (long)ioServiceCluster.batchFileSystems.size());
        Assert.assertTrue((boolean)ioServiceCluster.batchFileSystems.contains(((FileSystemId)mockedFSId).id()));
        ioServiceCluster.endBatch();
        ((IOServiceLockable)Mockito.verify((Object)serviceLockable, (VerificationMode)Mockito.times((int)3))).endBatch();
        Assert.assertEquals((long)0L, (long)ioServiceCluster.batchFileSystems.size());
        ((ClusterService)Mockito.verify((Object)clusterService, (VerificationMode)Mockito.times((int)3))).unlock();
    }

    private class TestWrapper
    extends IOServiceClusterImpl {
        public TestWrapper(ClusterService clusterService, IOServiceLockable service) {
            this.clusterService = clusterService;
            this.service = service;
        }
    }
}

