/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl.cluster.helix;

import java.util.HashMap;
import org.apache.helix.HelixManager;
import org.apache.helix.model.ExternalView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.commons.message.MessageHandlerResolver;
import org.uberfire.io.impl.cluster.helix.ClusterServiceHelix;

public class ClusterServiceHelixTest {
    ClusterServiceHelix clusterServiceHelix;
    ExternalView externalView;

    @Test
    public void getNodeStatusEmptyOrNullShouldReturnOfflineTest() {
        Mockito.when((Object)this.externalView.getStateMap("resourceName_0")).thenReturn(null);
        Assert.assertEquals((Object)"OFFLINE", (Object)this.clusterServiceHelix.getNodeStatus());
        HashMap emptyMap = new HashMap();
        Mockito.when((Object)this.externalView.getStateMap("resourceName_0")).thenReturn(emptyMap);
        Assert.assertEquals((Object)"OFFLINE", (Object)this.clusterServiceHelix.getNodeStatus());
    }

    @Test
    public void getNodeStatusTest() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("instanceName", "LEADER");
        Mockito.when((Object)this.externalView.getStateMap("resourceName_0")).thenReturn(valueMap);
        Assert.assertEquals((Object)"LEADER", (Object)this.clusterServiceHelix.getNodeStatus());
    }

    @Test
    public void getNodeStatusNullViewTest() {
        this.externalView = null;
        Assert.assertEquals((Object)"OFFLINE", (Object)this.clusterServiceHelix.getNodeStatus());
    }

    @Before
    public void setup() {
        this.externalView = (ExternalView)Mockito.mock(ExternalView.class);
        this.clusterServiceHelix = new ClusterServiceHelix("clusterName", "zkAddress", "instanceName", "resourceName", (MessageHandlerResolver)Mockito.mock(MessageHandlerResolver.class)){

            HelixManager getZkHelixManager(String clusterName, String zkAddress, String instanceName) {
                return (HelixManager)Mockito.mock(HelixManager.class);
            }

            void start() {
            }

            public void addMessageHandlerResolver(MessageHandlerResolver resolver) {
            }

            ExternalView getResourceExternalView() {
                return ClusterServiceHelixTest.this.externalView;
            }
        };
        Assert.assertTrue((boolean)PriorityDisposableRegistry.getDisposables().contains(this.clusterServiceHelix));
    }
}

