/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.io.CommonIOServiceDotFileTest;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.io.lock.BatchLockControl;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemImpl;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProxy;
import org.uberfire.java.nio.fs.jgit.ws.JGitWatchEvent;

public class BatchTest {
    static final IOService ioService = new IOServiceDotFileImpl();
    static FileSystem fs1;
    static JGitFileSystemImpl fs1Batch;
    static FileSystem fs2;
    static JGitFileSystemImpl fs2Batch;
    static FileSystem fs3;
    static JGitFileSystemImpl fs3Batch;
    private static File path;

    @BeforeClass
    public static void setup() throws IOException {
        Assert.assertTrue((boolean)PriorityDisposableRegistry.getDisposables().contains(ioService));
        path = CommonIOServiceDotFileTest.createTempDirectory();
        System.setProperty("org.uberfire.nio.git.dir", path.getAbsolutePath());
        System.out.println(".niogit: " + path.getAbsolutePath());
        URI newRepo = URI.create("git://amend-repo-test");
        fs1 = ioService.newFileSystem(newRepo, new HashMap());
        fs1Batch = (JGitFileSystemImpl)((JGitFileSystemProxy)fs1).getRealJGitFileSystem();
        Path init = ioService.get(URI.create("git://amend-repo-test/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
        URI newRepo2 = URI.create("git://check-amend-repo-test");
        fs2 = ioService.newFileSystem(newRepo2, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        fs2Batch = (JGitFileSystemImpl)((JGitFileSystemProxy)fs2).getRealJGitFileSystem();
        init = ioService.get(URI.create("git://check-amend-repo-test/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
        URI newRepo3 = URI.create("git://check-amend-repo-test-2");
        fs3 = ioService.newFileSystem(newRepo3, (Map)new HashMap<String, Object>(){
            {
                this.put("init", "true");
            }
        });
        fs3Batch = (JGitFileSystemImpl)((JGitFileSystemProxy)fs3).getRealJGitFileSystem();
        init = ioService.get(URI.create("git://check-amend-repo-test-2/init.file"));
        ioService.write(init, "setupFS!", new OpenOption[0]);
    }

    @AfterClass
    public static void cleanup() {
        FileUtils.deleteQuietly((File)path);
        JGitFileSystemProvider gitFsProvider = (JGitFileSystemProvider)FileSystemProviders.resolveProvider((URI)URI.create("git://whatever"));
        gitFsProvider.shutdown();
        FileUtils.deleteQuietly((File)gitFsProvider.getGitRepoContainerDir());
    }

    @Test
    public void deleteOnBatchEventShouldKeepUserInfo() {
        Path init = ioService.get(URI.create("git://amend-repo-test/file.txt"));
        WatchService ws = init.getFileSystem().newWatchService();
        String user = "dora";
        String message = "message";
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption(user, message)});
        List list = ws.poll().pollEvents();
        ioService.startBatch(init.getFileSystem());
        ioService.delete(init, new DeleteOption[]{new CommentedOption(user, message)});
        ioService.endBatch();
        List events = ws.poll().pollEvents();
        JGitWatchEvent event = (JGitWatchEvent)events.get(0);
        WatchContext context = (WatchContext)event.context();
        Assert.assertEquals((Object)user, (Object)context.getUser());
    }

    @Test
    public void testMoveAndAddOnBatchShouldTriggerRenameAndModifyEvent() {
        Path init = ioService.get(URI.create("git://amend-repo-test/file.txt"));
        Path initMoved = ioService.get(URI.create("git://amend-repo-test/fileMoved.txt"));
        WatchService ws = init.getFileSystem().newWatchService();
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        List events = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)StandardWatchEventKind.ENTRY_CREATE, (Object)((JGitWatchEvent)events.get(0)).kind());
        ioService.move(init, initMoved, new CopyOption[]{new CommentedOption("moved")});
        events = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)StandardWatchEventKind.ENTRY_RENAME, (Object)((JGitWatchEvent)events.get(0)).kind());
        Path aNewFile = ioService.get(URI.create("git://amend-repo-test/aNewFile.txt"));
        Path aNewFileMoved = ioService.get(URI.create("git://amend-repo-test/aNewFileMoved.txt"));
        ioService.write(aNewFile, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        List events2 = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events2.size());
        Assert.assertEquals((Object)StandardWatchEventKind.ENTRY_CREATE, (Object)((JGitWatchEvent)events2.get(0)).kind());
        ioService.startBatch(aNewFile.getFileSystem());
        ioService.move(aNewFile, aNewFileMoved, new CopyOption[]{new CommentedOption("moved")});
        ioService.write(aNewFileMoved, "aNewFileMoved!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.endBatch();
        Assert.assertEquals((Object)"aNewFileMoved!", (Object)ioService.readAllString(aNewFileMoved));
        events2 = ws.poll().pollEvents();
        Assert.assertEquals((long)2L, (long)events2.size());
        Assert.assertEquals((Object)StandardWatchEventKind.ENTRY_RENAME, (Object)((JGitWatchEvent)events2.get(0)).kind());
        Assert.assertEquals((Object)StandardWatchEventKind.ENTRY_MODIFY, (Object)((JGitWatchEvent)events2.get(1)).kind());
    }

    @Test
    public void testBatch() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        WatchService ws = init.getFileSystem().newWatchService();
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.write(init, "init 2!", new OpenOption[]{new CommentedOption("User Tester", "message2")});
        List events = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        Path init2 = ioService.get(URI.create("git://amend-repo-test/readme2.txt"));
        ioService.write(init2, "init 3!", new OpenOption[]{new CommentedOption("User Tester", "message3")});
        List events2 = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events2.size());
        ioService.write(init2, "init 4!", new OpenOption[]{new CommentedOption("User Tester", "message4")});
        events2 = ws.poll().pollEvents();
        Assert.assertEquals((long)1L, (long)events2.size());
        VersionAttributeView vinit = (VersionAttributeView)ioService.getFileAttributeView(init, VersionAttributeView.class);
        VersionAttributeView vinit2 = (VersionAttributeView)ioService.getFileAttributeView(init, VersionAttributeView.class);
        Assert.assertEquals((Object)"init 2!", (Object)ioService.readAllString(init));
        Assert.assertNotNull((Object)vinit);
        Assert.assertEquals((long)2L, (long)vinit.readAttributes().history().records().size());
        Assert.assertNotNull((Object)vinit2);
        Assert.assertEquals((long)2L, (long)vinit2.readAttributes().history().records().size());
        ioService.startBatch(init.getFileSystem());
        Path path = ioService.get(URI.create("git://amend-repo-test/mybatch" + new Random(10L).nextInt() + ".txt"));
        Path path2 = ioService.get(URI.create("git://amend-repo-test/mybatch2" + new Random(10L).nextInt() + ".txt"));
        ioService.write(path, "ooooo!", new OpenOption[0]);
        Assert.assertNotNull((Object)ws.poll());
        ioService.write(path, "ooooo wdfs fg sdf!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(path2, "ooooo222!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(path2, " sdfsdg sdg ooooo222!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch();
        List events3 = ws.poll().pollEvents();
        Assert.assertEquals((long)4L, (long)events3.size());
        VersionAttributeView v = (VersionAttributeView)ioService.getFileAttributeView(path, VersionAttributeView.class);
        VersionAttributeView v2 = (VersionAttributeView)ioService.getFileAttributeView(path2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)1L, (long)v.readAttributes().history().records().size());
        Assert.assertEquals((long)1L, (long)v2.readAttributes().history().records().size());
        this.assertProperBatchCleanup();
    }

    @Test
    public void testBatch2() throws IOException, InterruptedException {
        Path f1 = ioService.get(URI.create("git://check-amend-repo-test/f1.txt"));
        Path f2 = ioService.get(URI.create("git://check-amend-repo-test/f2.txt"));
        Path f3 = ioService.get(URI.create("git://check-amend-repo-test/f3.txt"));
        ioService.write(f1, "init f1!", new OpenOption[0]);
        ioService.write(f2, "init f2!", new OpenOption[0]);
        WatchService ws = f1.getFileSystem().newWatchService();
        ioService.startBatch(f1.getFileSystem());
        ioService.write(f1, "f1-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f2, "f2-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f3, "f3-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch();
        List events = ws.poll().pollEvents();
        Assert.assertEquals((long)3L, (long)events.size());
        VersionAttributeView v = (VersionAttributeView)ioService.getFileAttributeView(f1, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.readAttributes().history().records().size());
        VersionAttributeView v2 = (VersionAttributeView)ioService.getFileAttributeView(f2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)2L, (long)v2.readAttributes().history().records().size());
        VersionAttributeView v3 = (VersionAttributeView)ioService.getFileAttributeView(f3, VersionAttributeView.class);
        Assert.assertNotNull((Object)v3);
        Assert.assertEquals((long)1L, (long)v3.readAttributes().history().records().size());
        ioService.startBatch(f1.getFileSystem());
        ioService.write(f1, "f1-u1!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f2, "f2-u2!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.write(f3, "f3-u2!", new OpenOption[0]);
        Assert.assertNull((Object)ws.poll());
        ioService.endBatch();
        events = ws.poll().pollEvents();
        Assert.assertEquals((long)2L, (long)events.size());
        v = (VersionAttributeView)ioService.getFileAttributeView(f1, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.readAttributes().history().records().size());
        v2 = (VersionAttributeView)ioService.getFileAttributeView(f2, VersionAttributeView.class);
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((long)3L, (long)v2.readAttributes().history().records().size());
        v3 = (VersionAttributeView)ioService.getFileAttributeView(f3, VersionAttributeView.class);
        Assert.assertNotNull((Object)v3);
        Assert.assertEquals((long)2L, (long)v3.readAttributes().history().records().size());
        this.assertProperBatchCleanup();
    }

    @Test
    public void batchTest() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(fs1);
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        Assert.assertFalse((boolean)fs1Batch.isOnBatch());
        this.assertProperBatchCleanup();
    }

    @Test
    public void justOneFSOnBatchTest() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(fs1);
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        Assert.assertFalse((boolean)fs2Batch.isOnBatch());
        ioService.endBatch();
        this.assertProperBatchCleanup();
    }

    @Test
    public void testInnerBatch() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(fs1);
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.startBatch(fs1);
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        this.assertProperBatchCleanup();
    }

    @Test
    public void innerBatchShouldOnlyBeCalledOnTheSameFS() throws IOException, InterruptedException {
        Path repo1 = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(repo1, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        Path repo2 = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(repo2, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(fs1);
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        try {
            ioService.startBatch(fs2);
            Assert.fail();
        }
        catch (BatchLockControl.BatchRuntimeException batchRuntimeException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        this.assertProperBatchCleanup();
    }

    @Test
    public void assertNumberOfCommitsOnInnerBatch() throws IOException, InterruptedException {
        Path f11 = ioService.get(URI.create("git://check-amend-repo-test/f11.txt"));
        ioService.write(f11, "init f1!", new OpenOption[0]);
        ioService.startBatch(f11.getFileSystem());
        ioService.write(f11, "f1-u1!", new OpenOption[0]);
        ioService.endBatch();
        VersionAttributeView v = (VersionAttributeView)ioService.getFileAttributeView(f11, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.readAttributes().history().records().size());
        ioService.startBatch(f11.getFileSystem());
        ioService.write(f11, "f2-u2!", new OpenOption[0]);
        ioService.startBatch(f11.getFileSystem());
        ioService.write(f11, "f2-u2 - inner batch!", new OpenOption[0]);
        ioService.write(f11, "f2-u2 - inner 2 batch!", new OpenOption[0]);
        ioService.endBatch();
        ioService.write(f11, "f2-u2 - inner batch! last", new OpenOption[0]);
        ioService.endBatch();
        Assert.assertEquals((Object)"f2-u2 - inner batch! last", (Object)ioService.readAllString(f11));
        v = (VersionAttributeView)ioService.getFileAttributeView(f11, VersionAttributeView.class);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)4L, (long)v.readAttributes().history().records().size());
        this.assertProperBatchCleanup();
    }

    @Test
    public void testTwoStartedFsOnBatchByTheSameThread() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(fs1);
        try {
            ioService.startBatch(fs1);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ioService.endBatch();
        ioService.endBatch();
        try {
            ioService.endBatch();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertProperBatchCleanup();
    }

    @Test
    public void testTwoFsOnBatchByTheSameThread() throws IOException, InterruptedException {
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        init = ioService.get(URI.create("git://check-amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioService.startBatch(fs1);
        Assert.assertTrue((boolean)fs1Batch.isOnBatch());
        ioService.endBatch();
        ioService.startBatch(fs2);
        Assert.assertTrue((boolean)fs2Batch.isOnBatch());
        ioService.endBatch();
        this.assertProperBatchCleanup();
    }

    @Test
    public void testDifferentThreads() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        ioService.startBatch(fs1);
        System.out.println("After start batch");
        Thread thread = new Thread("second"){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    ioService.startBatch(fs1);
                    System.out.println("Inner after batch");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        innerOut.write(("sss" + i).getBytes());
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                    System.out.println("Inner after close");
                    ioService.endBatch();
                    System.out.println("Inner after end batch");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        thread.start();
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
        ioService.endBatch();
        System.out.println("After end batch");
        thread.join();
        this.assertProperBatchCleanup();
    }

    @Test
    public void testDifferentThreadsWithoutBatch() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        Thread thread = new Thread("second"){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        innerOut.write(("sss" + i).getBytes());
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        thread.start();
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
        thread.join();
        this.assertProperBatchCleanup();
    }

    @Test
    public void testDifferentThreads3() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        ioService.startBatch(fs1);
        System.out.println("After start batch");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    ioService.startBatch(fs1);
                    System.out.println("Inner after batch");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        innerOut.write(("sss" + i).getBytes());
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                    System.out.println("Inner after close");
                    ioService.endBatch();
                    System.out.println("Inner after end batch");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable, "second");
        Thread thread2 = new Thread(runnable, "third");
        thread.start();
        Thread.sleep(100L);
        thread2.start();
        Thread.sleep(100L);
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
        ioService.endBatch();
        System.out.println("After end batch");
        thread.join();
        thread2.join();
        this.assertProperBatchCleanup();
    }

    @Test
    public void testDifferentThreadsNotBatchInners() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        ioService.startBatch(fs1);
        System.out.println("After start batch");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        innerOut.write(("sss" + i).getBytes());
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                    System.out.println("Inner after end batch");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable, "second");
        Thread thread2 = new Thread(runnable, "third");
        thread.start();
        Thread.sleep(100L);
        thread2.start();
        Thread.sleep(100L);
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
        ioService.endBatch();
        System.out.println("After end batch");
        thread.join();
        thread2.join();
        this.assertProperBatchCleanup();
    }

    @Test
    public void testDifferentThreadsNotBatchOuter() throws IOException, InterruptedException {
        final Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioService.write(init, "init!", new OpenOption[0]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Inner starting");
                    ioService.startBatch(fs1);
                    System.out.println("Inner after batch");
                    OutputStream innerOut = ioService.newOutputStream(init, new OpenOption[0]);
                    for (int i = 0; i < 100; ++i) {
                        ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
                    }
                    System.out.println("Inner after write");
                    innerOut.close();
                    System.out.println("Inner after close");
                    ioService.endBatch();
                    System.out.println("Inner after end batch");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable, "second");
        Thread thread2 = new Thread(runnable, "third");
        thread.start();
        Thread.sleep(100L);
        thread2.start();
        Thread.sleep(100L);
        System.out.println("After start 2nd Thread");
        for (int i = 0; i < 100; ++i) {
            if (i % 20 == 0) {
                Thread.sleep(10L);
            }
            ioService.write(init, ("sss" + i).getBytes(), new OpenOption[0]);
        }
        System.out.println("After writes");
        thread.join();
        thread2.join();
        this.assertProperBatchCleanup();
    }

    @Test
    public void exceptionOnCleanUpAndUnsetBatchModeOnFileSystemsShouldReleaseLock() throws IOException, InterruptedException {
        IOServiceDotFileImpl ioServiceSpy = (IOServiceDotFileImpl)Mockito.spy((Object)((IOServiceDotFileImpl)ioService));
        ((IOServiceDotFileImpl)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)ioServiceSpy)).unsetBatchModeOn((FileSystem)fs1Batch);
        Path init = ioService.get(URI.create("git://amend-repo-test/readme.txt"));
        ioServiceSpy.write(init, "init!", new OpenOption[]{new CommentedOption("User Tester", "message1")});
        ioServiceSpy.startBatch(fs1);
        Assert.assertTrue((boolean)ioServiceSpy.getLockControl().isLocked());
        try {
            ioServiceSpy.endBatch();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)ioServiceSpy.getLockControl().isLocked());
    }

    private void assertProperBatchCleanup() {
        Assert.assertFalse((boolean)fs1Batch.isOnBatch());
        Assert.assertFalse((boolean)fs1Batch.isLocked());
        Assert.assertFalse((boolean)fs2Batch.isOnBatch());
        Assert.assertFalse((boolean)fs2Batch.isLocked());
        Assert.assertFalse((boolean)fs3Batch.isOnBatch());
        Assert.assertFalse((boolean)fs3Batch.isLocked());
    }

    static {
        path = null;
    }
}

