/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.io.CommonIOExceptionsServiceDotFileTest;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class GitIOServiceDotFileTest
extends CommonIOExceptionsServiceDotFileTest {
    private static boolean created = false;

    @Override
    protected int testFileAttrSize4() {
        return 9;
    }

    @Override
    protected int testFileAttrSize3() {
        return 12;
    }

    @Override
    protected int testFileAttrSize2() {
        return 12;
    }

    @Override
    protected int testFileAttrSize1() {
        return 12;
    }

    @Override
    protected int testDirectoryAttrSize4() {
        return 9;
    }

    @Override
    protected int testDirectoryAttrSize3() {
        return 12;
    }

    @Override
    protected int testDirectoryAttrSize2() {
        return 13;
    }

    @Override
    protected int testDirectoryAttrSize1() {
        return 12;
    }

    @Override
    protected int createDirectoriesAttrSize() {
        return 10;
    }

    @Override
    protected int testNewByteChannelAttrSize() {
        return 10;
    }

    @Test
    public void testGetFileSystems() {
        URI newRepo = URI.create("git://" + new Date().getTime() + "-repo-test");
        this.ioService().newFileSystem(newRepo, new HashMap());
        URI newRepo2 = URI.create("git://" + new Date().getTime() + "-repo2-test");
        this.ioService().newFileSystem(newRepo2, new HashMap());
        URI newRepo3 = URI.create("git://" + new Date().getTime() + "-repo3-test");
        this.ioService().newFileSystem(newRepo3, new HashMap());
        Iterator iterator = ioService.getFileSystemMetadata().iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testGetFileSystemInvalidURI() {
        URI uri = URI.create("git://" + new Date().getTime() + "-repo-test");
        FileSystem fs = this.ioService().getFileSystem(uri);
        Assert.assertNull((Object)fs);
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void testCreateFileSystemTwice() {
        URI uri = URI.create("git://" + new Date().getTime() + "-repo-test");
        this.ioService().newFileSystem(uri, new HashMap());
        this.ioService().newFileSystem(uri, new HashMap());
    }

    @Test
    public void testRoot() throws IOException {
        Path path = this.getRootPath();
        this.ioService().setAttributes(path, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "my_new_key";
            }

            public Object value() {
                return "value";
            }
        }});
        Map attrsValue = this.ioService().readAttributes(path);
        Assert.assertEquals((long)9L, (long)attrsValue.size());
        Assert.assertTrue((boolean)attrsValue.containsKey("my_new_key"));
        this.ioService().setAttributes(path, new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "my_new_key";
            }

            public Object value() {
                return null;
            }
        }});
        Map attrsValue2 = this.ioService().readAttributes(path);
        Assert.assertEquals((long)8L, (long)attrsValue2.size());
        Assert.assertFalse((boolean)attrsValue2.containsKey("my_new_key"));
    }

    @Override
    public Path getFilePath() {
        Path file = this.ioService().get(URI.create("git://repo-test/myfile" + new Random(10L).nextInt() + ".txt"));
        this.ioService().deleteIfExists(file, new DeleteOption[0]);
        return file;
    }

    @Override
    public Path getTargetPath() {
        Path file = this.ioService().get(URI.create("git://repo-test/myTargetFile" + new Random(10L).nextInt() + ".txt"));
        this.ioService().deleteIfExists(file, new DeleteOption[0]);
        return file;
    }

    @Override
    public Path getDirectoryPath() {
        Path dir = this.ioService().get(URI.create("git://repo-test/someDir" + new Random(10L).nextInt()));
        this.ioService().deleteIfExists(dir, new DeleteOption[0]);
        return dir;
    }

    @Override
    public Path getComposedDirectoryPath() {
        return this.ioService().get(URI.create("git://repo-test/path/to/someNewRandom" + new Random(10L).nextInt()));
    }

    private Path getRootPath() {
        return this.ioService().get(URI.create("git://repo-test/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws IOException {
        if (!created) {
            String path = GitIOServiceDotFileTest.createTempDirectory().getAbsolutePath();
            System.setProperty("org.uberfire.nio.git.dir", path);
            System.out.println(".niogit: " + path);
            URI newRepo = URI.create("git://repo-test");
            try {
                this.ioService().newFileSystem(newRepo, new HashMap());
            }
            catch (Exception exception) {
            }
            finally {
                created = true;
            }
        }
    }
}

