/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.exporter;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.exporter.JSExporterUtils;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.screen.JSNativeScreen;
import org.uberfire.client.screen.JSWorkbenchScreenActivity;

public class JSExporterUtilsTest {
    private SyncBeanManager beanManager;
    private JSWorkbenchScreenActivity screenActivity;
    private JSNativeScreen screen;

    @Before
    public void setup() {
        this.beanManager = (SyncBeanManager)Mockito.mock(SyncBeanManager.class);
        this.screen = (JSNativeScreen)Mockito.mock(JSNativeScreen.class);
        this.screenActivity = new JSWorkbenchScreenActivity(this.screen, (PlaceManager)Mockito.mock(PlaceManager.class));
        Mockito.when((Object)this.screen.getId()).thenReturn((Object)"id");
    }

    @Test
    public void testUpdateExistentActivity() {
        ArrayList<SyncBeanDef> activities = new ArrayList<SyncBeanDef>();
        activities.add(this.createActivityBeanDef((Activity)this.screenActivity));
        Mockito.when((Object)this.beanManager.lookupBeans((String)Mockito.any(String.class))).thenReturn(activities);
        JSWorkbenchScreenActivity activity = (JSWorkbenchScreenActivity)JSExporterUtils.findActivityIfExists((SyncBeanManager)this.beanManager, (String)this.screen.getId(), JSWorkbenchScreenActivity.class);
        Assert.assertNotNull((Object)activity);
    }

    @Test
    public void testTryUpdatingUnexistentActivity() {
        ArrayList activities = new ArrayList();
        Mockito.when((Object)this.beanManager.lookupBeans((String)Mockito.any(String.class))).thenReturn(activities);
        JSWorkbenchScreenActivity activity = (JSWorkbenchScreenActivity)JSExporterUtils.findActivityIfExists((SyncBeanManager)this.beanManager, (String)this.screen.getId(), JSWorkbenchScreenActivity.class);
        Assert.assertNull((Object)activity);
    }

    private SyncBeanDef createActivityBeanDef(final Activity activity) {
        return new SyncBeanDef(){

            public Object getInstance() {
                return activity;
            }

            public Object newInstance() {
                return null;
            }

            public boolean isAssignableTo(Class aClass) {
                return false;
            }

            public Class getType() {
                return null;
            }

            public Class<?> getBeanClass() {
                return null;
            }

            public Class<? extends Annotation> getScope() {
                return null;
            }

            public Set<Annotation> getQualifiers() {
                return null;
            }

            public boolean matches(Set set) {
                return false;
            }

            public String getName() {
                return null;
            }

            public boolean isActivated() {
                return false;
            }
        };
    }
}

