/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.impl.LayoutServicesImplTest;
import org.uberfire.ext.layout.editor.impl.LayoutUpgradeTool;

public class LayoutUpgradeToolTest {
    @Test
    public void testVersion1() throws Exception {
        String model = LayoutUpgradeToolTest.loadSample("12withHTMLComponent.txt");
        Assert.assertTrue((boolean)LayoutUpgradeTool.isVersion1((String)model));
    }

    @Test
    public void convertEmptyPerspectiveEditor() {
        String model = LayoutUpgradeToolTest.loadSample("DeprecatedEmptyPerspectiveEditor.txt");
        Assert.assertEquals((Object)LayoutTemplate.defaultLayout((String)"Empty"), (Object)LayoutUpgradeTool.convert((String)model));
    }

    @Test
    public void convertEmptyMoreColumnsPerspectiveEditor() {
        String model = LayoutUpgradeToolTest.loadSample("DeprecatedMoreColumnsPerspectiveEditor.txt");
        LayoutTemplate expected = this.generateEmptyMoreColumnsPerspectiveEditor();
        Assert.assertEquals((Object)expected, (Object)LayoutUpgradeTool.convert((String)model));
    }

    @Test
    public void convertComplexPerspectiveEditor() {
        String model = LayoutUpgradeToolTest.loadSample("DeprecatedComplexPerspectiveEditor.txt");
        LayoutTemplate expected = this.generateComplexPerspectiveEditor();
        LayoutTemplate actual = LayoutUpgradeTool.convert((String)model);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static String loadSample(String file) {
        try {
            return IOUtils.toString((InputStream)new LayoutServicesImplTest().getClass().getResourceAsStream(file), (String)"UTF-8");
        }
        catch (IOException e) {
            return "";
        }
    }

    private LayoutTemplate generateComplexPerspectiveEditor() {
        HashMap<String, String> property = new HashMap<String, String>();
        String tags = "tg1|tg2|tg3|";
        property.put("LAYOUT_TAGS", tags);
        LayoutTemplate template = new LayoutTemplate("Complex", property);
        LayoutRow layoutRow444 = new LayoutRow((List)new ArrayList<String>(){
            {
                this.add("4");
                this.add("4");
                this.add("4");
            }
        });
        LayoutColumn column1 = new LayoutColumn("4");
        LayoutComponent layoutComponent = new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.HTMLLayoutDragComponent");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("HTML_CODE", "<h1>eder</h1>");
        layoutComponent.addProperties(properties);
        column1.addLayoutComponent(layoutComponent);
        layoutRow444.add(column1);
        LayoutColumn column2 = new LayoutColumn("4");
        LayoutComponent layoutComponent2 = new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent");
        HashMap<String, String> properties2 = new HashMap<String, String>();
        properties2.put("Place Name", "screen1");
        layoutComponent2.addProperties(properties2);
        column2.addLayoutComponent(layoutComponent2);
        layoutRow444.add(column2);
        LayoutColumn column3 = new LayoutColumn("4");
        LayoutComponent layoutComponent3 = new LayoutComponent("org.dashbuilder.client.editor.DisplayerDragComponent");
        HashMap<String, String> properties3 = new HashMap<String, String>();
        properties3.put("Place Name", "screen2");
        layoutComponent3.addProperties(properties3);
        column3.addLayoutComponent(layoutComponent3);
        layoutRow444.add(column3);
        template.addRow(layoutRow444);
        return template;
    }

    private LayoutTemplate generateEmptyMoreColumnsPerspectiveEditor() {
        LayoutTemplate template = new LayoutTemplate("23");
        LayoutRow layoutRow12 = new LayoutRow((List)new ArrayList<String>(){
            {
                this.add("12");
            }
        });
        layoutRow12.add(new LayoutColumn("12"));
        template.addRow(layoutRow12);
        LayoutRow layoutRow6 = new LayoutRow((List)new ArrayList<String>(){
            {
                this.add("6");
                this.add("6");
            }
        });
        layoutRow6.add(new LayoutColumn("6"));
        layoutRow6.add(new LayoutColumn("6"));
        template.addRow(layoutRow6);
        LayoutRow layoutRow4 = new LayoutRow((List)new ArrayList<String>(){
            {
                this.add("4");
                this.add("4");
                this.add("4");
            }
        });
        layoutRow4.add(new LayoutColumn("4"));
        layoutRow4.add(new LayoutColumn("4"));
        layoutRow4.add(new LayoutColumn("4"));
        template.addRow(layoutRow4);
        return template;
    }
}

