/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.impl.old.perspective.editor.ColumnEditor;
import org.uberfire.ext.layout.editor.impl.old.perspective.editor.HTMLEditor;
import org.uberfire.ext.layout.editor.impl.old.perspective.editor.PerspectiveEditor;
import org.uberfire.ext.layout.editor.impl.old.perspective.editor.RowEditor;
import org.uberfire.ext.layout.editor.impl.old.perspective.editor.ScreenEditor;
import org.uberfire.ext.plugin.type.TagsConverterUtil;

public class LayoutUpgradeTool {
    static final String HTML_DRAG_TYPE = "org.uberfire.ext.plugin.client.perspective.editor.layout.editor.HTMLLayoutDragComponent";
    static final String SCREEN_DRAG_TYPE = "org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent";
    static final String DASHBUILDER_DRAG_TYPE = "org.dashbuilder.client.editor.DisplayerDragComponent";
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static boolean isVersion1(String layoutEditorModel) {
        return layoutEditorModel.contains("layoutProperties");
    }

    public static LayoutTemplate convert(String layoutEditorModel) {
        try {
            PerspectiveEditor editor = LayoutUpgradeTool.getPerspectiveEditor(layoutEditorModel);
            LayoutTemplate layoutTemplate = new LayoutTemplate(editor.getName());
            LayoutUpgradeTool.extractTags(editor, layoutTemplate);
            LayoutUpgradeTool.extractRows(editor.getRows(), layoutTemplate);
            return layoutTemplate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return LayoutTemplate.defaultLayout((String)"");
        }
    }

    private static void extractTags(PerspectiveEditor editor, LayoutTemplate layoutTemplate) {
        if (LayoutUpgradeTool.templateHasTags(editor)) {
            String tags = TagsConverterUtil.convertTagsToString(editor.getTags());
            layoutTemplate.addLayoutProperty("LAYOUT_TAGS", tags);
        }
    }

    private static boolean templateHasTags(PerspectiveEditor editor) {
        return editor.getTags() != null && !editor.getTags().isEmpty();
    }

    private static void extractRows(List<RowEditor> rows, LayoutTemplate layoutTemplate) {
        for (RowEditor rowEditor : rows) {
            LayoutRow layoutRow = new LayoutRow(rowEditor.getRowSpam());
            for (ColumnEditor columnEditor : rowEditor.getColumnEditors()) {
                LayoutColumn column = new LayoutColumn(columnEditor.getSpan());
                if (LayoutUpgradeTool.columnHasNestedRows(columnEditor)) {
                    LayoutUpgradeTool.extractRows(columnEditor.getRows(), layoutTemplate);
                } else {
                    LayoutUpgradeTool.generateScreens(columnEditor, column);
                    LayoutUpgradeTool.generateHTML(columnEditor, column);
                }
                layoutRow.add(column);
            }
            layoutTemplate.addRow(layoutRow);
        }
    }

    private static void generateHTML(ColumnEditor columnEditor, LayoutColumn column) {
        for (HTMLEditor htmlEditor : columnEditor.getHtmls()) {
            LayoutComponent layoutComponent = new LayoutComponent(HTML_DRAG_TYPE);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("HTML_CODE", htmlEditor.getHtmlCode());
            layoutComponent.addProperties(properties);
            column.addLayoutComponent(layoutComponent);
        }
    }

    private static void generateScreens(ColumnEditor columnEditor, LayoutColumn column) {
        for (ScreenEditor screenEditor : columnEditor.getScreens()) {
            String screenDragType = screenEditor.isAExternalComponent() ? DASHBUILDER_DRAG_TYPE : SCREEN_DRAG_TYPE;
            LayoutComponent layoutComponent = new LayoutComponent(screenDragType);
            layoutComponent.addProperties(screenEditor.getParameters());
            column.addLayoutComponent(layoutComponent);
        }
    }

    private static boolean columnHasNestedRows(ColumnEditor columnEditor) {
        return columnEditor.getRows() != null && !columnEditor.getRows().isEmpty();
    }

    private static PerspectiveEditor getPerspectiveEditor(String layoutEditorModel) {
        PerspectiveEditor perspectiveEditor = (PerspectiveEditor)gson.fromJson(layoutEditorModel, PerspectiveEditor.class);
        return perspectiveEditor;
    }
}

