/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.impl.LayoutServicesImpl;

public class LayoutServicesImplTest {
    private LayoutServicesImpl layoutServices;

    @Before
    public void setup() {
        this.layoutServices = new LayoutServicesImpl();
        this.layoutServices.init();
    }

    @Test
    public void layoutMarshaller12withHTMLComponent() {
        String expected = LayoutServicesImplTest.loadSample("12withHTMLComponent.txt");
        LayoutTemplate template = this.layoutServices.convertLayoutFromString(expected);
        String actual = this.layoutServices.convertLayoutToString(template);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void layoutMarshallerBigLayout() {
        String expected = LayoutServicesImplTest.loadSample("BigLayout.txt");
        LayoutTemplate template = this.layoutServices.convertLayoutFromString(expected);
        String actual = this.layoutServices.convertLayoutToString(template);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void layoutMarshallerSubColumns() {
        String expected = LayoutServicesImplTest.loadSample("SubColumnsLayout.txt");
        LayoutTemplate template = this.layoutServices.convertLayoutFromString(expected);
        String actual = this.layoutServices.convertLayoutToString(template);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static String loadSample(String file) {
        try {
            return IOUtils.toString((InputStream)new LayoutServicesImplTest().getClass().getResourceAsStream(file), (String)"UTF-8");
        }
        catch (IOException e) {
            return "";
        }
    }
}

