/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.impl;

import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.impl.LayoutServicesImpl;
import org.uberfire.ext.layout.editor.impl.PerspectiveServicesImpl;
import org.uberfire.ext.plugin.backend.PluginServicesImpl;
import org.uberfire.ext.plugin.model.LayoutEditorModel;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectiveServicesImplTest {
    @Mock
    PluginServicesImpl pluginServices;
    @Mock
    LayoutServicesImpl layoutServices;
    @Mock
    SaveAndRenameServiceImpl<LayoutTemplate, DefaultMetadata> saveAndRenameService;
    @Mock
    Path path;
    @Mock
    Path path2;
    @Mock
    DefaultMetadata metadata;
    @Mock
    Plugin plugin;
    PerspectiveServicesImpl perspectiveServices;

    @Before
    public void setup() {
        LayoutEditorModel layoutEditorModel = new LayoutEditorModel("layout", PluginType.PERSPECTIVE_LAYOUT, this.path2, "").emptyLayout();
        Mockito.when((Object)this.pluginServices.createNewPlugin(Mockito.anyString(), (PluginType)Mockito.any())).thenReturn((Object)this.plugin);
        Mockito.when((Object)this.plugin.getPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.pluginServices.copy((Path)Mockito.any(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.path2);
        Mockito.when((Object)this.pluginServices.copy((Path)Mockito.any(), Mockito.anyString(), (Path)Mockito.any(), Mockito.anyString())).thenReturn((Object)this.path2);
        Mockito.when((Object)this.pluginServices.rename((Path)Mockito.any(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.path2);
        Mockito.when((Object)this.pluginServices.getLayoutEditor((Path)Mockito.eq((Object)this.path2), (PluginType)Mockito.eq((Object)PluginType.PERSPECTIVE_LAYOUT))).thenReturn((Object)layoutEditorModel);
        this.perspectiveServices = (PerspectiveServicesImpl)Mockito.spy((Object)new PerspectiveServicesImpl(this.pluginServices, this.layoutServices, this.saveAndRenameService));
    }

    @Test
    public void testCreate() {
        this.perspectiveServices.createNewPerspective("test", LayoutTemplate.Style.FLUID);
        ArgumentCaptor arg1 = ArgumentCaptor.forClass(LayoutEditorModel.class);
        ((PluginServicesImpl)Mockito.verify((Object)this.pluginServices)).createNewPlugin("test", PluginType.PERSPECTIVE_LAYOUT);
        ((PluginServicesImpl)Mockito.verify((Object)this.pluginServices)).saveLayout((LayoutEditorModel)arg1.capture(), (String)Mockito.eq((Object)"Perspective 'test' check-in"));
        LayoutEditorModel layoutEditorModel = (LayoutEditorModel)arg1.getValue();
        Assert.assertEquals((Object)layoutEditorModel.getName(), (Object)"test");
    }

    @Test
    public void testList() {
        Plugin layoutPlugin = new Plugin("layout", PluginType.PERSPECTIVE_LAYOUT, this.path2);
        Mockito.when((Object)this.pluginServices.listPlugins()).thenReturn(Collections.singletonList(layoutPlugin));
        Collection layouts = this.perspectiveServices.listLayoutTemplates();
        Assert.assertEquals((long)layouts.size(), (long)1L);
        LayoutTemplate layoutTemplate = (LayoutTemplate)layouts.iterator().next();
        Assert.assertEquals((Object)layoutTemplate.getName(), (Object)"layout");
    }

    @Test
    public void testSave() {
        LayoutTemplate layoutTemplate = new LayoutTemplate("newName");
        Path savedPath = this.perspectiveServices.saveLayoutTemplate(this.path, layoutTemplate, "save");
        Assert.assertEquals((Object)savedPath, (Object)this.path);
        ArgumentCaptor layoutModelArg = ArgumentCaptor.forClass(LayoutEditorModel.class);
        ArgumentCaptor commitArg = ArgumentCaptor.forClass(String.class);
        ((PluginServicesImpl)Mockito.verify((Object)this.pluginServices)).saveLayout((LayoutEditorModel)layoutModelArg.capture(), (String)commitArg.capture());
        LayoutEditorModel layoutModelCopy = (LayoutEditorModel)layoutModelArg.getValue();
        Assert.assertEquals((Object)layoutModelCopy.getName(), (Object)"newName");
        Assert.assertEquals((Object)commitArg.getValue(), (Object)"save");
    }

    @Test
    public void testCopy() {
        Path result = this.perspectiveServices.copy(this.path, "newName", "");
        ArgumentCaptor layoutModelArg = ArgumentCaptor.forClass(LayoutEditorModel.class);
        ((PluginServicesImpl)Mockito.verify((Object)this.pluginServices)).saveLayout((LayoutEditorModel)layoutModelArg.capture(), Mockito.anyString());
        LayoutEditorModel layoutModelCopy = (LayoutEditorModel)layoutModelArg.getValue();
        Assert.assertEquals((Object)layoutModelCopy.getName(), (Object)"newName");
        Assert.assertEquals((Object)layoutModelCopy.getPath(), (Object)result);
    }

    @Test
    public void testCopyToTarget() {
        Path result = this.perspectiveServices.copy(this.path, "newName", this.path2, "");
        ArgumentCaptor layoutModelArg = ArgumentCaptor.forClass(LayoutEditorModel.class);
        ((PluginServicesImpl)Mockito.verify((Object)this.pluginServices)).saveLayout((LayoutEditorModel)layoutModelArg.capture(), Mockito.anyString());
        LayoutEditorModel layoutModelCopy = (LayoutEditorModel)layoutModelArg.getValue();
        Assert.assertEquals((Object)layoutModelCopy.getName(), (Object)"newName");
        Assert.assertEquals((Object)layoutModelCopy.getPath(), (Object)result);
        Assert.assertEquals((Object)result, (Object)this.path2);
    }

    @Test
    public void testRename() {
        Path result = this.perspectiveServices.rename(this.path, "newName", "");
        ArgumentCaptor layoutModelArg = ArgumentCaptor.forClass(LayoutEditorModel.class);
        ((PluginServicesImpl)Mockito.verify((Object)this.pluginServices)).saveLayout((LayoutEditorModel)layoutModelArg.capture(), Mockito.anyString());
        LayoutEditorModel layoutModelCopy = (LayoutEditorModel)layoutModelArg.getValue();
        Assert.assertEquals((Object)layoutModelCopy.getName(), (Object)"newName");
        Assert.assertEquals((Object)layoutModelCopy.getPath(), (Object)result);
    }

    @Test
    public void testDelete() {
        this.perspectiveServices.delete(this.path, "");
        ((PluginServicesImpl)Mockito.verify((Object)this.pluginServices)).delete(this.path, "");
    }

    @Test
    public void testInit() {
        this.perspectiveServices.init();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).init((SupportsSaveAndRename)this.perspectiveServices);
    }

    @Test
    public void testSaveFromSupportsUpdate() {
        String comment = "comment";
        LayoutTemplate content = new LayoutTemplate("name");
        this.perspectiveServices.save(this.path, content, this.metadata, "comment");
        ((PerspectiveServicesImpl)Mockito.verify((Object)this.perspectiveServices)).saveLayoutTemplate(this.path, content, "comment");
    }

    @Test
    public void testSaveAndRename() {
        String comment = "comment";
        String newFileName = "newFileName";
        LayoutTemplate content = new LayoutTemplate("name");
        this.perspectiveServices.saveAndRename(this.path, "newFileName", this.metadata, content, "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).saveAndRename(this.path, "newFileName", (Object)this.metadata, (Object)content, "comment");
    }
}

