/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.dnd;

import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.config.ColumnSizeConfigurator;
import com.github.gwtbootstrap.client.ui.config.DefaultColumnSizeConfigurator;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.fakes.FakeProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.client.components.LayoutComponentView;
import org.uberfire.ext.layout.editor.client.dnd.DropColumnPanel;
import org.uberfire.ext.layout.editor.client.resources.WebAppResource;
import org.uberfire.ext.layout.editor.client.row.RowView;
import org.uberfire.ext.layout.editor.client.structure.ColumnEditorUI;
import org.uberfire.ext.layout.editor.client.structure.EditorWidget;
import org.uberfire.ext.layout.editor.client.structure.RowEditorWidgetUI;
import org.uberfire.ext.layout.editor.client.util.LayoutDragComponent;

@RunWith(value=GwtMockitoTestRunner.class)
public class DropColumnPanelTest {
    private DropColumnPanel dropColumnPanel;
    private FlowPanel columnContainer;
    private LayoutDragComponent layoutDragComponent;
    private Modal componentConfigureModal;

    @Before
    public void setup() {
        GwtMockito.useProviderForType(ColumnSizeConfigurator.class, (FakeProvider)new FakeProvider(){

            public Object getFake(Class aClass) {
                return new DefaultColumnSizeConfigurator();
            }
        });
        this.layoutDragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.componentConfigureModal = (Modal)Mockito.mock(Modal.class);
        Mockito.when((Object)this.layoutDragComponent.getConfigureModal((EditorWidget)Mockito.any(EditorWidget.class))).thenReturn((Object)this.componentConfigureModal);
        this.columnContainer = (FlowPanel)Mockito.mock(FlowPanel.class);
        ColumnEditorUI columnEditorUI = new ColumnEditorUI((RowEditorWidgetUI)Mockito.mock(RowEditorWidgetUI.class), this.columnContainer, "12");
        this.dropColumnPanel = (DropColumnPanel)Mockito.spy((Object)new DropColumnPanel(columnEditorUI){

            LayoutDragComponent getLayoutDragComponent(String dragTypeClassName) {
                return DropColumnPanelTest.this.layoutDragComponent;
            }
        });
    }

    @Test
    public void onDragOverShouldCreateABorderAndDragLeaveShouldRemoveTheBorder() {
        this.dropColumnPanel.dragOverHandler();
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).addCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
        this.dropColumnPanel.dragLeaveHandler();
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).removeCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
    }

    @Test
    public void dropHandlerOfAGridTest() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        Mockito.when((Object)event.getData("INTERNAL_DRAG_COMPONENT")).thenReturn((Object)"12");
        this.dropColumnPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(RowView.class));
    }

    @Test
    public void handleExternalLayoutDropComponent() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        Mockito.when((Object)event.getData(LayoutDragComponent.class.toString())).thenReturn((Object)"dragClass");
        this.dropColumnPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(LayoutComponentView.class));
        ((Modal)Mockito.verify((Object)this.componentConfigureModal, (VerificationMode)Mockito.never())).show();
        Mockito.when((Object)this.layoutDragComponent.hasConfigureModal()).thenReturn((Object)true);
        this.dropColumnPanel.dropHandler(event);
        ((Modal)Mockito.verify((Object)this.componentConfigureModal, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void handleExternalLayoutDropComponentWithConfigureModal() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        Mockito.when((Object)event.getData(LayoutDragComponent.class.toString())).thenReturn((Object)"dragClass");
        Mockito.when((Object)this.layoutDragComponent.hasConfigureModal()).thenReturn((Object)true);
        this.dropColumnPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(LayoutComponentView.class));
        ((Modal)Mockito.verify((Object)this.componentConfigureModal, (VerificationMode)Mockito.times((int)1))).show();
    }
}

