/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import com.github.gwtbootstrap.client.ui.config.ColumnSizeConfigurator;
import com.github.gwtbootstrap.client.ui.config.DefaultColumnSizeConfigurator;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.fakes.FakeProvider;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.uberfire.ext.layout.editor.api.editor.ColumnEditor;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutEditor;
import org.uberfire.ext.layout.editor.api.editor.RowEditor;
import org.uberfire.ext.layout.editor.client.LayoutEditorPresenter;
import org.uberfire.ext.layout.editor.client.LayoutEditorView;
import org.uberfire.ext.layout.editor.client.components.LayoutComponentView;
import org.uberfire.ext.layout.editor.client.row.RowView;
import org.uberfire.ext.layout.editor.client.structure.ColumnEditorUI;
import org.uberfire.ext.layout.editor.client.structure.EditorWidget;
import org.uberfire.ext.layout.editor.client.structure.LayoutComponentWidgetUI;
import org.uberfire.ext.layout.editor.client.structure.LayoutEditorUI;
import org.uberfire.ext.layout.editor.client.structure.RowEditorWidgetUI;
import org.uberfire.ext.layout.editor.client.util.LayoutDragComponent;

@RunWith(value=GwtMockitoTestRunner.class)
public class LayoutEditorViewTest {
    LayoutEditorUI layoutEditorUI;
    LayoutEditorView view;

    @Before
    public void setup() {
        GwtMockito.useProviderForType(ColumnSizeConfigurator.class, (FakeProvider)new FakeProvider(){

            public Object getFake(Class aClass) {
                return new DefaultColumnSizeConfigurator();
            }
        });
        this.layoutEditorUI = new LayoutEditorUI();
        this.view = new LayoutEditorView(this.layoutEditorUI);
        LayoutEditorPresenter presenter = new LayoutEditorPresenter((LayoutEditorPresenter.View)this.view);
        this.view.init(presenter);
    }

    @Test
    public void createAndExtractDefaultModel() throws Exception {
        this.view.loadDefaultContent("layout");
        LayoutEditor model = this.view.getModel();
        Assert.assertEquals((Object)LayoutEditor.defaultContent((String)"layout"), (Object)model);
        this.view.setupContent(LayoutEditor.defaultContent((String)"layout"));
        model = this.view.getModel();
        Assert.assertEquals((Object)LayoutEditor.defaultContent((String)"layout"), (Object)model);
    }

    @Test
    public void addAndGetLayoutProperty() throws Exception {
        this.view.addLayoutProperty("key", "value");
        String value = this.view.getLayoutProperty("key");
        Assert.assertEquals((Object)"value", (Object)value);
        Map layoutProperties = this.view.getModel().getLayoutProperties();
        value = (String)layoutProperties.get("key");
        Assert.assertEquals((Object)"value", (Object)value);
    }

    @Test
    public void addAndGetLayoutComponentProperty() throws Exception {
        this.view.setupContent(LayoutEditor.defaultContent((String)"layout"));
        RowEditorWidgetUI firstDefaultRow = (RowEditorWidgetUI)this.layoutEditorUI.getRowEditors().get(0);
        ColumnEditorUI firstDefaultColumn = (ColumnEditorUI)firstDefaultRow.getColumnEditors().get(0);
        LayoutComponentWidgetUI editorWidget = new LayoutComponentWidgetUI((EditorWidget)firstDefaultColumn, new FlowPanel(), (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class));
        firstDefaultColumn.addChild((EditorWidget)editorWidget);
        this.view.addComponentProperty((EditorWidget)editorWidget, "key", "value");
        Assert.assertEquals((Object)"value", this.view.getLayoutComponentProperties((EditorWidget)editorWidget).get("key"));
        this.view.resetLayoutComponentProperties((EditorWidget)editorWidget);
        Assert.assertEquals(null, this.view.getLayoutComponentProperties((EditorWidget)editorWidget).get("key"));
        this.view.addComponentProperty((EditorWidget)editorWidget, "key", "value");
        Assert.assertEquals((Object)"value", this.view.getLayoutComponentProperties((EditorWidget)editorWidget).get("key"));
        this.view.removeLayoutComponentProperty((EditorWidget)editorWidget, "key");
        Assert.assertEquals(null, this.view.getLayoutComponentProperties((EditorWidget)editorWidget).get("key"));
    }

    @Test
    public void propertyShouldBeOnLayoutModelAndOnLayoutUI() throws Exception {
        this.view.setupContent(LayoutEditor.defaultContent((String)"layout"));
        RowEditorWidgetUI firstDefaultRow = (RowEditorWidgetUI)this.layoutEditorUI.getRowEditors().get(0);
        ColumnEditorUI firstDefaultColumn = (ColumnEditorUI)firstDefaultRow.getColumnEditors().get(0);
        LayoutComponentWidgetUI editorWidget = new LayoutComponentWidgetUI((EditorWidget)firstDefaultColumn, new FlowPanel(), (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class));
        firstDefaultColumn.addChild((EditorWidget)editorWidget);
        this.view.addComponentProperty((EditorWidget)editorWidget, "key", "value");
        LayoutComponent firstComponent = this.extractFirstLayoutComponent(this.view);
        Map properties = firstComponent.getProperties();
        Assert.assertEquals((Object)"value", properties.get("key"));
    }

    @Test
    public void loadAnLayoutEditor() {
        LayoutDragComponent layoutDragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.view = this.createViewMock(layoutDragComponent);
        LayoutEditorPresenter presenter = new LayoutEditorPresenter((LayoutEditorPresenter.View)this.view);
        this.view.init(presenter);
        LayoutEditor layout = LayoutEditor.defaultContent((String)"layout");
        RowEditor row = (RowEditor)layout.getRows().get(0);
        ColumnEditor columnEditor = (ColumnEditor)row.getColumnEditors().get(0);
        LayoutComponent layoutComponent = new LayoutComponent(LayoutDragComponent.class);
        layoutComponent.addProperty("key", "value");
        columnEditor.addLayoutComponent(layoutComponent);
        this.view.setupContent(layout);
        LayoutComponent layoutComponentExtracted = this.extractFirstLayoutComponent(this.view);
        Assert.assertEquals((Object)"value", layoutComponentExtracted.getProperties().get("key"));
    }

    private LayoutComponent extractFirstLayoutComponent(LayoutEditorView view) {
        LayoutEditor model = view.getModel();
        RowEditor firstRow = (RowEditor)model.getRows().get(0);
        ColumnEditor firstColumn = (ColumnEditor)firstRow.getColumnEditors().get(0);
        return (LayoutComponent)firstColumn.getLayoutComponents().get(0);
    }

    private LayoutEditorView createViewMock(final LayoutDragComponent layoutDragComponent) {
        return new LayoutEditorView(this.layoutEditorUI){

            RowView createRowView(RowEditor row) {
                RowView rowView = new RowView(this.layoutEditorUI, row){

                    public LayoutDragComponent getLayoutDragComponent(LayoutComponent layoutComponent) {
                        return layoutDragComponent;
                    }

                    protected LayoutComponentView createLayoutComponentView(ColumnEditorUI parent, LayoutComponent layoutComponent, LayoutDragComponent layoutDragComponent) {
                        return new LayoutComponentView(parent, layoutComponent, layoutDragComponent){

                            protected LayoutEditorUI getLayoutEditor() {
                                return layoutEditorUI;
                            }
                        };
                    }
                };
                return rowView;
            }
        };
    }
}

