/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.dnd;

import com.github.gwtbootstrap.client.ui.config.ColumnSizeConfigurator;
import com.github.gwtbootstrap.client.ui.config.DefaultColumnSizeConfigurator;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.fakes.FakeProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.api.editor.LayoutEditor;
import org.uberfire.ext.layout.editor.client.dnd.DropRowPanel;
import org.uberfire.ext.layout.editor.client.resources.WebAppResource;
import org.uberfire.ext.layout.editor.client.row.RowView;
import org.uberfire.ext.layout.editor.client.structure.LayoutEditorUI;

@RunWith(value=GwtMockitoTestRunner.class)
public class DropRowPanelTest {
    private LayoutEditorUI layoutEditorUI;
    private DropRowPanel dropRowPanel;
    private FlowPanel dropPanel;

    @Before
    public void setup() {
        GwtMockito.useProviderForType(ColumnSizeConfigurator.class, (FakeProvider)new FakeProvider(){

            public Object getFake(Class aClass) {
                return new DefaultColumnSizeConfigurator();
            }
        });
        this.dropPanel = (FlowPanel)Mockito.mock(FlowPanel.class);
        this.layoutEditorUI = new LayoutEditorUI();
        this.layoutEditorUI.setup(this.dropPanel, new LayoutEditor());
        this.dropRowPanel = new DropRowPanel(this.layoutEditorUI);
    }

    @Test
    public void dropHandlerOfAGridTest() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        Mockito.when((Object)event.getData("INTERNAL_DRAG_COMPONENT")).thenReturn((Object)"12");
        this.dropRowPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.dropPanel)).remove((Widget)this.dropRowPanel);
        ((FlowPanel)Mockito.verify((Object)this.dropPanel, (VerificationMode)Mockito.atLeastOnce())).add((Widget)Mockito.any(RowView.class));
        ((FlowPanel)Mockito.verify((Object)this.dropPanel, (VerificationMode)Mockito.atLeastOnce())).add((Widget)Mockito.any(DropRowPanel.class));
    }

    @Test
    public void dropHandlerOfWrongComponentTest() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        Mockito.when((Object)event.getData("INTERNAL_DRAG_COMPONENT")).thenReturn((Object)"");
        this.dropRowPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.dropPanel, (VerificationMode)Mockito.never())).remove((Widget)this.dropRowPanel);
        ((FlowPanel)Mockito.verify((Object)this.dropPanel, (VerificationMode)Mockito.never())).add((Widget)Mockito.any(Widget.class));
    }

    @Test
    public void onDragOverShouldCreateABorderAndDragLeaveShouldRemoveTheBorder() {
        DropRowPanel spy = (DropRowPanel)Mockito.spy((Object)this.dropRowPanel);
        spy.dragOverHandler();
        ((DropRowPanel)Mockito.verify((Object)spy)).addCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
        spy.dragLeaveHandler();
        ((DropRowPanel)Mockito.verify((Object)spy)).removeCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
    }
}

