/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.dnd;

import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.config.ColumnSizeConfigurator;
import com.github.gwtbootstrap.client.ui.config.DefaultColumnSizeConfigurator;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.fakes.FakeProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.client.components.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.components.LayoutComponentView;
import org.uberfire.ext.layout.editor.client.components.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.components.RenderingContext;
import org.uberfire.ext.layout.editor.client.dnd.DropColumnPanel;
import org.uberfire.ext.layout.editor.client.resources.WebAppResource;
import org.uberfire.ext.layout.editor.client.row.RowView;
import org.uberfire.ext.layout.editor.client.structure.ColumnEditorWidget;
import org.uberfire.ext.layout.editor.client.structure.EditorWidget;
import org.uberfire.ext.layout.editor.client.structure.LayoutEditorWidget;
import org.uberfire.ext.layout.editor.client.structure.RowEditorWidget;

@RunWith(value=GwtMockitoTestRunner.class)
public class DropColumnPanelTest {
    private DropColumnPanel dropColumnPanel;
    private FlowPanel columnContainer;
    private LayoutDragComponent layoutDragComponent;
    private ModalDragComponent modalDragComponent;
    private Modal componentConfigureModal;

    @Before
    public void setup() {
        GwtMockito.useProviderForType(ColumnSizeConfigurator.class, (FakeProvider)new FakeProvider(){

            public Object getFake(Class aClass) {
                return new DefaultColumnSizeConfigurator();
            }
        });
        this.modalDragComponent = (ModalDragComponent)Mockito.mock(ModalDragComponent.class);
        this.layoutDragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.componentConfigureModal = (Modal)Mockito.mock(Modal.class);
        Mockito.when((Object)this.modalDragComponent.getConfigurationModal((ModalConfigurationContext)Mockito.any(ModalConfigurationContext.class))).thenReturn((Object)this.componentConfigureModal);
        this.columnContainer = (FlowPanel)Mockito.mock(FlowPanel.class);
        ColumnEditorWidget columnEditorWidget = new ColumnEditorWidget((RowEditorWidget)Mockito.mock(RowEditorWidget.class), this.columnContainer, "12"){

            public EditorWidget getParent() {
                return new LayoutEditorWidget();
            }
        };
        this.dropColumnPanel = (DropColumnPanel)Mockito.spy((Object)new DropColumnPanel(columnEditorWidget){

            LayoutDragComponent getLayoutDragComponent(String dragTypeClassName) {
                if (ModalDragComponent.class.getName().equals(dragTypeClassName)) {
                    return DropColumnPanelTest.this.modalDragComponent;
                }
                return DropColumnPanelTest.this.layoutDragComponent;
            }
        });
    }

    @Test
    public void onDragOverShouldCreateABorderAndDragLeaveShouldRemoveTheBorder() {
        this.dropColumnPanel.dragOverHandler();
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).removeCSSClass(WebAppResource.INSTANCE.CSS().dropInactive());
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).addCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
        this.dropColumnPanel.dragLeaveHandler();
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).removeCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).addCSSClass(WebAppResource.INSTANCE.CSS().dropInactive());
    }

    @Test
    public void dropHandlerOfAGridTest() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        Mockito.when((Object)event.getData("INTERNAL_DRAG_COMPONENT")).thenReturn((Object)"12");
        this.dropColumnPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(RowView.class));
    }

    @Test
    public void handleExternalLayoutDropComponent() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        Mockito.when((Object)event.getData(LayoutDragComponent.class.toString())).thenReturn((Object)"dragClass");
        this.dropColumnPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(LayoutComponentView.class));
        ((Modal)Mockito.verify((Object)this.componentConfigureModal, (VerificationMode)Mockito.never())).show();
    }

    @Test
    public void handleExternalLayoutDropComponentWithConfigureModal() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        Mockito.when((Object)event.getData(LayoutDragComponent.class.toString())).thenReturn((Object)ModalDragComponent.class.getName());
        this.dropColumnPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(LayoutComponentView.class));
        ((Modal)Mockito.verify((Object)this.componentConfigureModal, (VerificationMode)Mockito.times((int)1))).show();
    }

    class ModalDragComponent
    implements LayoutDragComponent,
    HasModalConfiguration {
        ModalDragComponent() {
        }

        public Modal getConfigurationModal(ModalConfigurationContext ctx) {
            return DropColumnPanelTest.this.componentConfigureModal;
        }

        public IsWidget getDragWidget() {
            return null;
        }

        public IsWidget getPreviewWidget(RenderingContext ctx) {
            return null;
        }

        public IsWidget getShowWidget(RenderingContext ctx) {
            return null;
        }
    }
}

