/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.dnd;

import com.google.gwt.dom.client.DataTransfer;
import com.google.gwt.event.dom.client.DragStartEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.uberfire.ext.layout.editor.client.components.GridLayoutDragComponent;
import org.uberfire.ext.layout.editor.client.components.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.dnd.DndDataJSONConverter;
import org.uberfire.ext.layout.editor.client.dnd.DragGridElement;
import org.uberfire.ext.layout.editor.client.dnd.mocks.DndDataJSONConverterMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DragGridElementTest {
    public static final String SPAN = "12";
    private GridLayoutDragComponent internalType;
    private LayoutDragComponent externalType;
    private DragGridElement internalGridElement;
    private DragGridElement externalGridElement;

    @Before
    public void setup() {
        this.internalType = (GridLayoutDragComponent)Mockito.mock(GridLayoutDragComponent.class);
        this.externalType = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.internalGridElement = new DragGridElement((LayoutDragComponent)this.internalType);
        this.externalGridElement = new DragGridElement(this.externalType);
    }

    @Test
    public void createDragStartExternalComponent() throws Exception {
        DragStartEvent dragStartEvent = (DragStartEvent)Mockito.mock(DragStartEvent.class);
        Mockito.when((Object)dragStartEvent.getDataTransfer()).thenReturn(Mockito.mock(DataTransfer.class));
        DndDataJSONConverterMock converter = new DndDataJSONConverterMock();
        this.externalGridElement.setConverter((DndDataJSONConverter)converter);
        this.externalGridElement.createDragStart(dragStartEvent, this.externalType);
        String data = converter.generateDragComponentJSON(this.externalType);
        ((DragStartEvent)Mockito.verify((Object)dragStartEvent)).setData("text", data);
    }

    @Test
    public void createDragStartInternalComponent() throws Exception {
        DragStartEvent dragStartEvent = (DragStartEvent)Mockito.mock(DragStartEvent.class);
        Mockito.when((Object)dragStartEvent.getDataTransfer()).thenReturn(Mockito.mock(DataTransfer.class));
        Mockito.when((Object)this.internalType.getSpan()).thenReturn((Object)SPAN);
        Mockito.when((Object)this.internalType.getSettingsKeys()).thenReturn((Object)new String[]{"span"});
        Mockito.when((Object)this.internalType.getSettingValue("span")).thenReturn((Object)SPAN);
        DndDataJSONConverterMock converter = new DndDataJSONConverterMock();
        String data = converter.generateDragComponentJSON((LayoutDragComponent)this.internalType);
        this.internalGridElement.setConverter((DndDataJSONConverter)converter);
        this.internalGridElement.createDragStart(dragStartEvent, (LayoutDragComponent)this.internalType);
        ((DragStartEvent)Mockito.verify((Object)dragStartEvent)).setData("text", data);
    }
}

