/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.dnd;

import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.Modal;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.client.components.GridLayoutDragComponent;
import org.uberfire.ext.layout.editor.client.components.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.components.LayoutComponentView;
import org.uberfire.ext.layout.editor.client.components.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.components.RenderingContext;
import org.uberfire.ext.layout.editor.client.dnd.DndDataJSONConverter;
import org.uberfire.ext.layout.editor.client.dnd.DropColumnPanel;
import org.uberfire.ext.layout.editor.client.dnd.mocks.DndDataJSONConverterMock;
import org.uberfire.ext.layout.editor.client.resources.WebAppResource;
import org.uberfire.ext.layout.editor.client.row.RowView;
import org.uberfire.ext.layout.editor.client.structure.ColumnEditorWidget;
import org.uberfire.ext.layout.editor.client.structure.EditorWidget;
import org.uberfire.ext.layout.editor.client.structure.LayoutEditorWidget;
import org.uberfire.ext.layout.editor.client.structure.RowEditorWidget;

@RunWith(value=GwtMockitoTestRunner.class)
public class DropColumnPanelTest {
    public static final String SPAN = "12";
    private DropColumnPanel dropColumnPanel;
    private FlowPanel columnContainer;
    private GridLayoutDragComponent gridLayoutComponent;
    private LayoutDragComponent layoutDragComponent;
    private ModalDragComponent modalDragComponent;
    private Modal componentConfigureModal;

    @Before
    public void setup() {
        this.gridLayoutComponent = (GridLayoutDragComponent)Mockito.mock(GridLayoutDragComponent.class);
        Mockito.when((Object)this.gridLayoutComponent.getSpan()).thenReturn((Object)SPAN);
        Mockito.when((Object)this.gridLayoutComponent.getSettingsKeys()).thenReturn((Object)new String[]{"span"});
        Mockito.when((Object)this.gridLayoutComponent.getSettingValue("span")).thenReturn((Object)SPAN);
        Mockito.when((Object)this.gridLayoutComponent.getSpan()).thenReturn((Object)SPAN);
        this.layoutDragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.modalDragComponent = (ModalDragComponent)Mockito.mock(ModalDragComponent.class);
        this.componentConfigureModal = (Modal)Mockito.mock(Modal.class);
        Mockito.when((Object)this.modalDragComponent.getConfigurationModal((ModalConfigurationContext)Mockito.any(ModalConfigurationContext.class))).thenReturn((Object)this.componentConfigureModal);
        this.columnContainer = (FlowPanel)Mockito.mock(FlowPanel.class);
        ColumnEditorWidget columnEditorWidget = new ColumnEditorWidget((RowEditorWidget)Mockito.mock(RowEditorWidget.class), (ComplexPanel)this.columnContainer, SPAN){

            public EditorWidget getParent() {
                return new LayoutEditorWidget();
            }
        };
        this.dropColumnPanel = (DropColumnPanel)Mockito.spy((Object)new DropColumnPanel(columnEditorWidget));
    }

    @Test
    public void onDragOverShouldCreateABorderAndDragLeaveShouldRemoveTheBorder() {
        this.dropColumnPanel.dragOverHandler();
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).removeCSSClass(WebAppResource.INSTANCE.CSS().dropInactive());
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).addCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
        this.dropColumnPanel.dragLeaveHandler();
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).removeCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
        ((DropColumnPanel)Mockito.verify((Object)this.dropColumnPanel)).addCSSClass(WebAppResource.INSTANCE.CSS().dropInactive());
    }

    @Test
    public void dropHandlerOfAGridTest() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        DndDataJSONConverterMock converter = new DndDataJSONConverterMock();
        String data = converter.generateDragComponentJSON((LayoutDragComponent)this.gridLayoutComponent);
        Mockito.when((Object)event.getData("text")).thenReturn((Object)data);
        this.dropColumnPanel.setConverter((DndDataJSONConverter)converter);
        this.dropColumnPanel.dropHandler(event);
        ((GridLayoutDragComponent)Mockito.verify((Object)this.gridLayoutComponent, (VerificationMode)Mockito.atLeastOnce())).getSettingsKeys();
        ((GridLayoutDragComponent)Mockito.verify((Object)this.gridLayoutComponent)).getSettingValue("span");
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(RowView.class));
    }

    @Test
    public void handleExternalLayoutDropComponent() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        DndDataJSONConverterMock converter = new DndDataJSONConverterMock();
        String data = converter.generateDragComponentJSON(this.layoutDragComponent);
        Mockito.when((Object)event.getData("text")).thenReturn((Object)data);
        this.dropColumnPanel.setConverter((DndDataJSONConverter)converter);
        this.dropColumnPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(LayoutComponentView.class));
        ((Modal)Mockito.verify((Object)this.componentConfigureModal, (VerificationMode)Mockito.never())).show();
    }

    @Test
    public void handleExternalLayoutDropComponentWithConfigureModal() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        DndDataJSONConverterMock converter = new DndDataJSONConverterMock();
        String data = converter.generateDragComponentJSON(this.modalDragComponent);
        Mockito.when((Object)event.getData("text")).thenReturn((Object)data);
        this.dropColumnPanel.setConverter((DndDataJSONConverter)converter);
        this.dropColumnPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer)).remove((Widget)this.dropColumnPanel);
        ((FlowPanel)Mockito.verify((Object)this.columnContainer, (VerificationMode)Mockito.times((int)1))).add((Widget)Mockito.any(LayoutComponentView.class));
        ((Modal)Mockito.verify((Object)this.componentConfigureModal, (VerificationMode)Mockito.times((int)1))).show();
    }

    class ModalDragComponent
    implements LayoutDragComponent,
    HasModalConfiguration {
        ModalDragComponent() {
        }

        public Modal getConfigurationModal(ModalConfigurationContext ctx) {
            return DropColumnPanelTest.this.componentConfigureModal;
        }

        public IsWidget getDragWidget() {
            return null;
        }

        public IsWidget getPreviewWidget(RenderingContext ctx) {
            return null;
        }

        public IsWidget getShowWidget(RenderingContext ctx) {
            return null;
        }
    }
}

