/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.dnd;

import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.components.GridLayoutDragComponent;
import org.uberfire.ext.layout.editor.client.components.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.dnd.DndDataJSONConverter;
import org.uberfire.ext.layout.editor.client.dnd.DropRowPanel;
import org.uberfire.ext.layout.editor.client.dnd.mocks.DndDataJSONConverterMock;
import org.uberfire.ext.layout.editor.client.resources.WebAppResource;
import org.uberfire.ext.layout.editor.client.row.RowView;
import org.uberfire.ext.layout.editor.client.structure.LayoutEditorWidget;

@RunWith(value=GwtMockitoTestRunner.class)
public class DropRowPanelTest {
    public static final String SPAN = "12";
    private GridLayoutDragComponent gridLayoutDragComponent;
    private LayoutEditorWidget layoutEditorWidget;
    private DropRowPanel dropRowPanel;
    private FlowPanel dropPanel;

    @Before
    public void setup() {
        this.gridLayoutDragComponent = (GridLayoutDragComponent)Mockito.mock(GridLayoutDragComponent.class);
        this.dropPanel = (FlowPanel)Mockito.mock(FlowPanel.class);
        this.layoutEditorWidget = new LayoutEditorWidget();
        this.layoutEditorWidget.setup((ComplexPanel)this.dropPanel, new LayoutTemplate());
        this.dropRowPanel = new DropRowPanel(this.layoutEditorWidget);
    }

    @Test
    public void dropHandlerOfAGridTest() {
        Mockito.when((Object)this.gridLayoutDragComponent.getSpan()).thenReturn((Object)SPAN);
        Mockito.when((Object)this.gridLayoutDragComponent.getSettingsKeys()).thenReturn((Object)new String[]{"span"});
        Mockito.when((Object)this.gridLayoutDragComponent.getSettingValue("span")).thenReturn((Object)SPAN);
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        DndDataJSONConverterMock converter = new DndDataJSONConverterMock();
        String data = converter.generateDragComponentJSON((LayoutDragComponent)this.gridLayoutDragComponent);
        Mockito.when((Object)event.getData("text")).thenReturn((Object)data);
        this.dropRowPanel.setConverter((DndDataJSONConverter)converter);
        this.dropRowPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.dropPanel)).remove((Widget)this.dropRowPanel);
        ((FlowPanel)Mockito.verify((Object)this.dropPanel, (VerificationMode)Mockito.atLeastOnce())).add((Widget)Mockito.any(RowView.class));
        ((FlowPanel)Mockito.verify((Object)this.dropPanel, (VerificationMode)Mockito.atLeastOnce())).add((Widget)Mockito.any(DropRowPanel.class));
    }

    @Test
    public void dropHandlerOfWrongComponentTest() {
        DropEvent event = (DropEvent)Mockito.mock(DropEvent.class);
        DndDataJSONConverterMock converter = new DndDataJSONConverterMock();
        String data = converter.generateDragComponentJSON((LayoutDragComponent)this.gridLayoutDragComponent);
        Mockito.when((Object)event.getData("text")).thenReturn((Object)data);
        this.dropRowPanel.setConverter((DndDataJSONConverter)converter);
        this.dropRowPanel.dropHandler(event);
        ((FlowPanel)Mockito.verify((Object)this.dropPanel, (VerificationMode)Mockito.never())).remove((Widget)this.dropRowPanel);
        ((FlowPanel)Mockito.verify((Object)this.dropPanel, (VerificationMode)Mockito.never())).add((Widget)Mockito.any(Widget.class));
    }

    @Test
    public void onDragOverShouldCreateABorderAndDragLeaveShouldRemoveTheBorder() {
        DropRowPanel spy = (DropRowPanel)Mockito.spy((Object)this.dropRowPanel);
        spy.dragOverHandler();
        ((DropRowPanel)Mockito.verify((Object)spy)).addCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
        spy.dragLeaveHandler();
        ((DropRowPanel)Mockito.verify((Object)spy)).removeCSSClass(WebAppResource.INSTANCE.CSS().dropBorder());
    }
}

