/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.LayoutEditorPresenter;
import org.uberfire.ext.layout.editor.client.LayoutEditorView;
import org.uberfire.ext.layout.editor.client.components.LayoutComponentView;
import org.uberfire.ext.layout.editor.client.components.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.row.RowView;
import org.uberfire.ext.layout.editor.client.structure.ColumnEditorWidget;
import org.uberfire.ext.layout.editor.client.structure.ComponentEditorWidget;
import org.uberfire.ext.layout.editor.client.structure.EditorWidget;
import org.uberfire.ext.layout.editor.client.structure.LayoutEditorWidget;
import org.uberfire.ext.layout.editor.client.structure.RowEditorWidget;

@RunWith(value=GwtMockitoTestRunner.class)
public class LayoutTemplateViewTest {
    LayoutEditorWidget layoutEditorWidget;
    LayoutEditorView view;

    @Before
    public void setup() {
        this.layoutEditorWidget = new LayoutEditorWidget();
        this.view = new LayoutEditorView(this.layoutEditorWidget);
        LayoutEditorPresenter presenter = new LayoutEditorPresenter((LayoutEditorPresenter.View)this.view);
        this.view.init(presenter);
    }

    @Test
    public void createAndExtractDefaultModel() throws Exception {
        this.view.loadDefaultLayout("layout");
        LayoutTemplate model = this.view.getModel();
        Assert.assertEquals((Object)LayoutTemplate.defaultLayout((String)"layout"), (Object)model);
        this.view.setupContent(LayoutTemplate.defaultLayout((String)"layout"));
        model = this.view.getModel();
        Assert.assertEquals((Object)LayoutTemplate.defaultLayout((String)"layout"), (Object)model);
    }

    @Test
    public void addAndGetLayoutProperty() throws Exception {
        this.view.addLayoutProperty("key", "value");
        String value = this.view.getLayoutProperty("key");
        Assert.assertEquals((Object)"value", (Object)value);
        Map layoutProperties = this.view.getModel().getLayoutProperties();
        value = (String)layoutProperties.get("key");
        Assert.assertEquals((Object)"value", (Object)value);
    }

    @Test
    public void addAndGetLayoutComponentProperty() throws Exception {
        this.view.setupContent(LayoutTemplate.defaultLayout((String)"layout"));
        RowEditorWidget firstDefaultRow = (RowEditorWidget)this.layoutEditorWidget.getRowEditors().get(0);
        ColumnEditorWidget firstDefaultColumn = (ColumnEditorWidget)firstDefaultRow.getColumnEditors().get(0);
        ComponentEditorWidget editorWidget = new ComponentEditorWidget((EditorWidget)firstDefaultColumn, (ComplexPanel)new FlowPanel(), (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class));
        firstDefaultColumn.addChild((EditorWidget)editorWidget);
        this.view.addComponentProperty((EditorWidget)editorWidget, "key", "value");
        Assert.assertEquals((Object)"value", this.view.getLayoutComponentProperties((EditorWidget)editorWidget).get("key"));
        this.view.resetLayoutComponentProperties((EditorWidget)editorWidget);
        Assert.assertEquals(null, this.view.getLayoutComponentProperties((EditorWidget)editorWidget).get("key"));
        this.view.addComponentProperty((EditorWidget)editorWidget, "key", "value");
        Assert.assertEquals((Object)"value", this.view.getLayoutComponentProperties((EditorWidget)editorWidget).get("key"));
        this.view.removeLayoutComponentProperty((EditorWidget)editorWidget, "key");
        Assert.assertEquals(null, this.view.getLayoutComponentProperties((EditorWidget)editorWidget).get("key"));
    }

    @Test
    public void propertyShouldBeOnLayoutModelAndOnLayoutUI() throws Exception {
        this.view.setupContent(LayoutTemplate.defaultLayout((String)"layout"));
        RowEditorWidget firstDefaultRow = (RowEditorWidget)this.layoutEditorWidget.getRowEditors().get(0);
        ColumnEditorWidget firstDefaultColumn = (ColumnEditorWidget)firstDefaultRow.getColumnEditors().get(0);
        ComponentEditorWidget editorWidget = new ComponentEditorWidget((EditorWidget)firstDefaultColumn, (ComplexPanel)new FlowPanel(), (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class));
        firstDefaultColumn.addChild((EditorWidget)editorWidget);
        this.view.addComponentProperty((EditorWidget)editorWidget, "key", "value");
        LayoutComponent firstComponent = this.extractFirstLayoutComponent(this.view);
        Map properties = firstComponent.getProperties();
        Assert.assertEquals((Object)"value", properties.get("key"));
    }

    @Test
    public void loadAnLayoutEditor() {
        LayoutDragComponent layoutDragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.view = this.createViewMock(layoutDragComponent);
        LayoutEditorPresenter presenter = new LayoutEditorPresenter((LayoutEditorPresenter.View)this.view);
        this.view.init(presenter);
        LayoutTemplate layout = LayoutTemplate.defaultLayout((String)"layout");
        LayoutRow row = (LayoutRow)layout.getRows().get(0);
        LayoutColumn layoutColumn = (LayoutColumn)row.getLayoutColumns().get(0);
        LayoutComponent layoutComponent = new LayoutComponent(LayoutDragComponent.class);
        layoutComponent.addProperty("key", "value");
        layoutColumn.addLayoutComponent(layoutComponent);
        this.view.setupContent(layout);
        LayoutComponent layoutComponentExtracted = this.extractFirstLayoutComponent(this.view);
        Assert.assertEquals((Object)"value", layoutComponentExtracted.getProperties().get("key"));
    }

    private LayoutComponent extractFirstLayoutComponent(LayoutEditorView view) {
        LayoutTemplate model = view.getModel();
        LayoutRow firstRow = (LayoutRow)model.getRows().get(0);
        LayoutColumn firstColumn = (LayoutColumn)firstRow.getLayoutColumns().get(0);
        return (LayoutComponent)firstColumn.getLayoutComponents().get(0);
    }

    private LayoutEditorView createViewMock(final LayoutDragComponent layoutDragComponent) {
        return new LayoutEditorView(this.layoutEditorWidget){

            RowView createRowView(LayoutRow row) {
                RowView rowView = new RowView(this.layoutEditorWidget, row){

                    public LayoutDragComponent getLayoutDragComponent(LayoutComponent layoutComponent) {
                        return layoutDragComponent;
                    }

                    protected LayoutComponentView createLayoutComponentView(ColumnEditorWidget parent, LayoutComponent layoutComponent, LayoutDragComponent layoutDragComponent) {
                        return new LayoutComponentView(parent, layoutComponent, layoutDragComponent){

                            protected LayoutEditorWidget getLayoutEditorWidget() {
                                return layoutEditorWidget;
                            }
                        };
                    }
                };
                return rowView;
            }
        };
    }
}

