/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.components;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.AbstractLayoutEditorTest;
import org.uberfire.ext.layout.editor.client.components.columns.Column;
import org.uberfire.ext.layout.editor.client.components.columns.ColumnWithComponents;
import org.uberfire.ext.layout.editor.client.components.rows.Row;
import org.uberfire.ext.layout.editor.client.components.rows.RowDrop;
import org.uberfire.ext.layout.editor.client.infra.ColumnDrop;
import org.uberfire.ext.layout.editor.client.infra.ColumnResizeEvent;

public class FullLayoutTest
extends AbstractLayoutEditorTest {
    @Test
    public void testFullLayout() throws Exception {
        this.container.setLayoutName("A");
        this.container.addProperty("LAYOUT_TAGS", "a|");
        this.createFirstRow();
        this.createSecondRow();
        LayoutTemplate layoutTemplate = this.container.toLayoutTemplate();
        Assert.assertEquals((Object)this.convertLayoutToString(this.loadLayout("org/uberfire/ext/layout/editor/client/fullLayout.txt")), (Object)this.convertLayoutToString(layoutTemplate));
    }

    private void createSecondRow() {
        Row firstRow = this.getRowByIndex(0);
        this.container.createRowDropCommand().execute((Object)new RowDrop(new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent"), firstRow.hashCode(), RowDrop.Orientation.AFTER));
        Column column = this.getColumnByIndex(this.getRowByIndex(1), 0);
        column.getLayoutComponent().addProperty("Place Name", "DoraScreen");
    }

    private void createFirstRow() {
        Column firstRowFirstColumn = this.createFirstRowFirstColumn();
        this.createFirstRowSecondColumn(firstRowFirstColumn);
    }

    private void dropTwoInnerColumnsInSecondRow() {
        Row row = this.getRowByIndex(0);
        Column secondColumn = this.getColumnByIndex(row, 1);
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent"), secondColumn.hashCode(), ColumnDrop.Orientation.DOWN));
        ColumnWithComponents columnWithComponents = (ColumnWithComponents)this.getColumnByIndex(row, 1);
        Column newColumn = this.getColumnByIndex(columnWithComponents.getRow(), 1);
        newColumn.getLayoutComponent().addProperty("c", "c");
        newColumn.getLayoutComponent().addProperty("Place Name", "AnotherScreen");
    }

    private void resizeColumnsFor_8_4() {
        Row row = this.getRowByIndex(0);
        row.resizeColumns(new ColumnResizeEvent(this.getColumnByIndex(row, 1).hashCode(), row.hashCode()).right());
        row.resizeColumns(new ColumnResizeEvent(this.getColumnByIndex(row, 1).hashCode(), row.hashCode()).right());
    }

    private void createFirstRowSecondColumn(Column firstRowFirstColumn) {
        Row row = this.getRowByIndex(0);
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.HTML"), firstRowFirstColumn.hashCode(), ColumnDrop.Orientation.RIGHT));
        Column htmlColumn = this.getColumnByIndex(row, 1);
        htmlColumn.getLayoutComponent().addProperty("HTML_CODE", "c");
        this.resizeColumnsFor_8_4();
        this.dropTwoInnerColumnsInSecondRow();
    }

    private Column createFirstRowFirstColumn() {
        this.container.createEmptyDropCommand().execute((Object)new RowDrop(new LayoutComponent("org.uberfire.ext.plugin.client.perspective.editor.layout.editor.ScreenLayoutDragComponent"), this.emptyDropRow.hashCode(), RowDrop.Orientation.BEFORE));
        Column appHomePresenter = this.getColumnByIndex(this.getRowByIndex(0), 0);
        appHomePresenter.getLayoutComponent().addProperty("Place Name", "AppsHomePresenter");
        return appHomePresenter;
    }
}

