/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.components.container;

import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.AbstractLayoutEditorTest;
import org.uberfire.ext.layout.editor.client.components.columns.Column;
import org.uberfire.ext.layout.editor.client.components.columns.ComponentColumn;
import org.uberfire.ext.layout.editor.client.components.container.Container;
import org.uberfire.ext.layout.editor.client.components.rows.Row;
import org.uberfire.ext.layout.editor.client.components.rows.RowDnDEvent;
import org.uberfire.ext.layout.editor.client.components.rows.RowDrop;
import org.uberfire.mvp.ParameterizedCommand;

public class ContainerTest
extends AbstractLayoutEditorTest {
    @Test
    public void assertEmptyContainerHasEmptyDropRow() {
        Assert.assertTrue((boolean)this.container.getRows().isEmpty());
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.view)).addEmptyRow(this.emptyDropRow.getView());
    }

    @Test
    public void createFirstRow() {
        Util.assertEquals((Object)0, (Object)this.getRowsSizeFromContainer());
        Assert.assertNotNull((Object)this.container.getEmptyDropRow());
        ((Container.View)Mockito.verify((Object)this.view)).addEmptyRow(this.emptyDropRow.getView());
        this.container.createEmptyDropCommand().execute((Object)new RowDrop(new LayoutComponent("dragType"), this.emptyDropRow.hashCode(), RowDrop.Orientation.BEFORE));
        Util.assertEquals((Object)1, (Object)this.getRowsSizeFromContainer());
    }

    @Test
    public void loadAndExportLayout() throws Exception {
        LayoutTemplate expected = this.loadLayout("org/uberfire/ext/layout/editor/client/sampleFullLayout.txt");
        LayoutTemplate actual = this.container.toLayoutTemplate();
        Util.assertEquals((Object)expected, (Object)actual);
        Util.assertEquals((Object)this.convertLayoutToString(expected), (Object)this.convertLayoutToString(actual));
    }

    @Test
    public void dropBeforeComponentShouldCreateANewRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt");
        Row dropRow = this.getRowByIndex(0);
        RowDrop dropNewComponentOnFirstRow = new RowDrop(new LayoutComponent("dragType"), dropRow.hashCode(), RowDrop.Orientation.BEFORE);
        dropNewComponentOnFirstRow.newComponent();
        this.container.createRowDropCommand().execute((Object)dropNewComponentOnFirstRow);
        Util.assertEquals((Object)2, (Object)this.getRowsSizeFromContainer());
        Column droppedColumn = this.getColumnByIndex(this.getRowByIndex(0), 0);
        Util.assertEquals((Object)"dragType", (Object)droppedColumn.getLayoutComponent().getDragTypeName());
        Util.assertEquals((Object)dropRow, (Object)this.getRowByIndex(1));
    }

    @Test
    public void moveComponentShouldRemoveComponentFromCurrentRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row dropRow = this.getRowByIndex(0);
        RowDrop moveComponentAndDropInFirstRow = new RowDrop(new LayoutComponent("dragType"), dropRow.hashCode(), RowDrop.Orientation.BEFORE);
        moveComponentAndDropInFirstRow.fromMove(dropRow.hashCode(), this.getColumns(dropRow).get(0));
        this.container.createRowDropCommand().execute((Object)moveComponentAndDropInFirstRow);
        Util.assertEquals((Object)2, (Object)this.getRowsSizeFromContainer());
        Util.assertEquals((Object)1, (Object)this.getColumns(this.getRowByIndex(0)).size());
        Util.assertEquals((Object)1, (Object)this.getColumns(this.getRowByIndex(1)).size());
    }

    @Test
    public void swapRows() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/sampleFullLayout.txt");
        Row row1 = this.getRowByIndex(0);
        Row row2 = this.getRowByIndex(1);
        this.container.swapRows(new RowDnDEvent(row1.hashCode(), row2.hashCode(), RowDrop.Orientation.AFTER));
        Util.assertEquals((Object)row2, (Object)this.getRowByIndex(0));
        Util.assertEquals((Object)row1, (Object)this.getRowByIndex(1));
    }

    @Test
    public void dropAfterComponentShouldCreateANewRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt");
        Row dropRow = this.getRowByIndex(0);
        ParameterizedCommand rowDropCommand = this.container.createRowDropCommand();
        RowDrop drop = new RowDrop(new LayoutComponent("dragType"), dropRow.hashCode(), RowDrop.Orientation.AFTER);
        drop.newComponent();
        rowDropCommand.execute((Object)drop);
        Util.assertEquals((Object)2, (Object)this.getRowsSizeFromContainer());
        Util.assertEquals((Object)dropRow, (Object)this.getRowByIndex(0));
    }

    @Test
    public void removeSingleComponentFromRowShouldRemoveRow() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt");
        Assert.assertFalse((boolean)this.container.getRows().isEmpty());
        Row row = this.getRowByIndex(0);
        ComponentColumn column = (ComponentColumn)this.getColumns(row).get(0);
        column.remove();
        Assert.assertTrue((boolean)this.container.getRows().isEmpty());
    }

    @Test
    public void addGetPropertyTest() throws Exception {
        Assert.assertNull((Object)this.container.getProperty("key"));
        this.container.addProperty("key", "value");
        Assert.assertNotNull((Object)this.container.getProperty("key"));
        Assert.assertTrue((boolean)this.container.getProperties().containsKey("key"));
    }
}

