/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.infra;

import org.jboss.errai.common.client.dom.HTMLElement;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.client.infra.CSSClassNameHelper;

public class CSSClassNameHelperTest {
    HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);

    @Test
    public void hasClassName() {
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"dora dora1");
        Assert.assertTrue((boolean)CSSClassNameHelper.hasClassName((HTMLElement)this.element, (String)"dora"));
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"dora1 dora2");
        Assert.assertFalse((boolean)CSSClassNameHelper.hasClassName((HTMLElement)this.element, (String)"dora"));
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"   ");
        Assert.assertFalse((boolean)CSSClassNameHelper.hasClassName((HTMLElement)this.element, (String)"dora"));
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"");
        Assert.assertFalse((boolean)CSSClassNameHelper.hasClassName((HTMLElement)this.element, (String)"dora"));
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"     dora       dora1");
        Assert.assertTrue((boolean)CSSClassNameHelper.hasClassName((HTMLElement)this.element, (String)"dora"));
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"dora dora1 dora2");
        Assert.assertTrue((boolean)CSSClassNameHelper.hasClassName((HTMLElement)this.element, (String)"dora2"));
    }

    @Test
    public void removeClassName() {
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"dora dora1");
        CSSClassNameHelper.removeClassName((HTMLElement)this.element, (String)"dora");
        ((HTMLElement)Mockito.verify((Object)this.element)).setClassName("dora1");
        CSSClassNameHelper.removeClassName((HTMLElement)this.element, (String)"dora2");
        ((HTMLElement)Mockito.verify((Object)this.element)).setClassName("dora1");
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"dora");
        CSSClassNameHelper.removeClassName((HTMLElement)this.element, (String)"dora");
        ((HTMLElement)Mockito.verify((Object)this.element)).setClassName("");
    }

    @Test
    public void addClassName() {
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"");
        CSSClassNameHelper.addClassName((HTMLElement)this.element, (String)"dora");
        ((HTMLElement)Mockito.verify((Object)this.element)).setClassName("dora");
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"dora dora1");
        CSSClassNameHelper.addClassName((HTMLElement)this.element, (String)"dora");
        ((HTMLElement)Mockito.verify((Object)this.element, (VerificationMode)Mockito.never())).setClassName("dora dora1");
        CSSClassNameHelper.addClassName((HTMLElement)this.element, (String)"dora2");
        ((HTMLElement)Mockito.verify((Object)this.element)).setClassName("dora dora1 dora2");
        Mockito.when((Object)this.element.getClassName()).thenReturn((Object)"dora");
        CSSClassNameHelper.addClassName((HTMLElement)this.element, (String)"dora");
        ((HTMLElement)Mockito.verify((Object)this.element)).setClassName("dora");
    }
}

