/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client.components.rows;

import java.util.List;
import org.jgroups.util.Util;
import org.junit.Test;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.client.AbstractLayoutEditorTest;
import org.uberfire.ext.layout.editor.client.components.columns.Column;
import org.uberfire.ext.layout.editor.client.components.columns.ColumnWithComponents;
import org.uberfire.ext.layout.editor.client.components.rows.Row;
import org.uberfire.ext.layout.editor.client.infra.ColumnDrop;
import org.uberfire.ext.layout.editor.client.infra.ColumnResizeEvent;

public class RowTest
extends AbstractLayoutEditorTest {
    @Test
    public void dropOnLeftColumn() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column dropColumn = this.getColumnByIndex(row, 0);
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("dragType"), dropColumn.getId(), ColumnDrop.Orientation.LEFT));
        Column newColumn = this.getColumnByIndex(row, 0);
        Util.assertEquals((Object)3, (Object)row.getColumns().size());
        Util.assertEquals((Object)"dragType", (Object)newColumn.getLayoutComponent().getDragTypeName());
        Util.assertEquals((Object)dropColumn, (Object)this.getColumnByIndex(row, 1));
    }

    @Test
    public void dropOnRightColumn() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column dropColumn = this.getColumnByIndex(row, 0);
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("dragType"), dropColumn.getId(), ColumnDrop.Orientation.RIGHT));
        Column newColumn = this.getColumnByIndex(row, 1);
        Util.assertEquals((Object)3, (Object)row.getColumns().size());
        Util.assertEquals((Object)"dragType", (Object)newColumn.getLayoutComponent().getDragTypeName());
        Util.assertEquals((Object)dropColumn, (Object)this.getColumnByIndex(row, 0));
    }

    @Test
    public void dropAboveColumnShouldCreateColumnWithComponents() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column dropColumn = this.getColumnByIndex(row, 0);
        LayoutComponent originalColumnLayoutComponent = dropColumn.getLayoutComponent();
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("dragType"), dropColumn.getId(), ColumnDrop.Orientation.DOWN));
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        ColumnWithComponents columnWithComponents = (ColumnWithComponents)this.getColumnByIndex(row, 0);
        List<Column> childs = this.extractColumnsFrom(columnWithComponents);
        Util.assertEquals((Object)2, (Object)childs.size());
        Util.assertEquals((Object)originalColumnLayoutComponent, (Object)childs.get(0).getLayoutComponent());
        LayoutComponent newColumnLayoutComponent = childs.get(1).getLayoutComponent();
        Util.assertEquals((Object)"dragType", (Object)newColumnLayoutComponent.getDragTypeName());
    }

    @Test
    public void dropUpperColumnShouldCreateColumnWithComponents() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column dropColumn = this.getColumnByIndex(row, 1);
        LayoutComponent originalColumnLayoutComponent = dropColumn.getLayoutComponent();
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        row.dropCommand().execute((Object)new ColumnDrop(new LayoutComponent("dragType"), dropColumn.getId(), ColumnDrop.Orientation.UP));
        Util.assertEquals((Object)2, (Object)row.getColumns().size());
        ColumnWithComponents columnWithComponents = (ColumnWithComponents)this.getColumnByIndex(row, 1);
        List<Column> childs = this.extractColumnsFrom(columnWithComponents);
        Util.assertEquals((Object)2, (Object)childs.size());
        LayoutComponent newColumnLayoutComponent = childs.get(0).getLayoutComponent();
        Util.assertEquals((Object)"dragType", (Object)newColumnLayoutComponent.getDragTypeName());
        Util.assertEquals((Object)originalColumnLayoutComponent, (Object)childs.get(1).getLayoutComponent());
    }

    @Test
    public void resizeEventTest() throws Exception {
        this.loadLayout("org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt");
        Row row = this.getRowByIndex(0);
        Column first = this.getColumnByIndex(row, 0);
        Column second = this.getColumnByIndex(this.getRowByIndex(0), 1);
        Integer originalFirstSize = first.getSize();
        Integer originalSecondSize = second.getSize();
        row.resizeColumns(new ColumnResizeEvent(second.getId(), row.getId()).left());
        Util.assertEquals((Object)(originalFirstSize - 1), (Object)first.getSize());
        Util.assertEquals((Object)(originalSecondSize + 1), (Object)second.getSize());
        row.resizeColumns(new ColumnResizeEvent(second.getId(), row.getId()).left());
        Util.assertEquals((Object)(originalFirstSize - 2), (Object)first.getSize());
        Util.assertEquals((Object)(originalSecondSize + 2), (Object)second.getSize());
        row.resizeColumns(new ColumnResizeEvent(first.getId(), row.getId()).right());
        Util.assertEquals((Object)(originalFirstSize - 1), (Object)first.getSize());
        Util.assertEquals((Object)(originalSecondSize + 1), (Object)second.getSize());
    }
}

