/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.api.ComponentDropEvent;
import org.uberfire.ext.layout.editor.client.api.ComponentRemovedEvent;
import org.uberfire.ext.layout.editor.client.components.columns.Column;
import org.uberfire.ext.layout.editor.client.components.columns.ColumnWithComponents;
import org.uberfire.ext.layout.editor.client.components.columns.ComponentColumn;
import org.uberfire.ext.layout.editor.client.components.container.Container;
import org.uberfire.ext.layout.editor.client.components.rows.EmptyDropRow;
import org.uberfire.ext.layout.editor.client.components.rows.Row;
import org.uberfire.ext.layout.editor.client.infra.DnDManager;
import org.uberfire.ext.layout.editor.client.infra.LayoutDragComponentHelper;
import org.uberfire.ext.layout.editor.client.infra.UniqueIDGenerator;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractLayoutEditorTest {
    public static final String SAMPLE_FULL_FLUID_LAYOUT = "org/uberfire/ext/layout/editor/client/sampleFullFluidLayout.txt";
    public static final String SAMPLE_FULL_PAGE_LAYOUT = "org/uberfire/ext/layout/editor/client/sampleFullPageLayout.txt";
    public static final String SINGLE_ROW_COMPONENT_LAYOUT = "org/uberfire/ext/layout/editor/client/singleRowComponentLayout.txt";
    public static final String SINGLE_ROW_TWO_COMPONENTS_LAYOUT = "org/uberfire/ext/layout/editor/client/singleRowTwoComponentsLayout.txt";
    public static final String FULL_LAYOUT_FLUID = "org/uberfire/ext/layout/editor/client/fullLayoutFluid.txt";
    public static final String FULL_LAYOUT_PAGE = "org/uberfire/ext/layout/editor/client/fullLayoutPage.txt";
    public static final int EMPTY_ROW = 0;
    public static final int FIRST_ROW = 0;
    public static final int SECOND_ROW = 1;
    public static final int FIRST_COLUMN = 0;
    public static final int SECOND_COLUMN = 1;
    @Mock
    protected Instance<Row> rowInstance;
    @Mock
    protected Instance<EmptyDropRow> emptyDropRowInstance;
    @Mock
    protected Container.View view;
    @Mock
    protected LayoutDragComponentHelper helper;
    @Mock
    protected EventSourceMock<ComponentDropEvent> componentDropEventMock;
    @Mock
    protected EventSourceMock<ComponentRemovedEvent> componentRemoveEventMock;
    protected EmptyDropRow emptyDropRow;
    protected DnDManager dnDManager;
    protected Container container;
    private Gson gson;

    public AbstractLayoutEditorTest() {
        this.emptyDropRow = new EmptyDropRow((EmptyDropRow.View)Mockito.mock(EmptyDropRow.View.class), this.helper);
        this.dnDManager = new DnDManager();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public Container createContainer() {
        return new Container(this.view, (Instance)this.rowInstance, (Instance)this.emptyDropRowInstance, (Event)this.componentDropEventMock){
            private UniqueIDGenerator idGenerator;
            {
                this.idGenerator = new UniqueIDGenerator();
            }

            protected EmptyDropRow createInstanceEmptyDropRow() {
                AbstractLayoutEditorTest.this.emptyDropRow.setId(this.idGenerator.createRowID("container"));
                return AbstractLayoutEditorTest.this.emptyDropRow;
            }

            protected Row createInstanceRow() {
                Row row = AbstractLayoutEditorTest.this.rowProducer();
                row.setup(this.idGenerator.createRowID("container"), LayoutTemplate.Style.PAGE);
                return row;
            }

            protected void destroy(Object o) {
            }
        };
    }

    private Row rowProducer() {
        return new Row((Row.View)Mockito.mock(Row.View.class), null, null, this.dnDManager, this.helper, (Event)this.componentDropEventMock, (Event)this.componentRemoveEventMock, null){
            private UniqueIDGenerator idGenerator;
            {
                this.idGenerator = new UniqueIDGenerator();
            }

            protected ComponentColumn createComponentColumnInstance() {
                ComponentColumn componentColumn = new ComponentColumn((ComponentColumn.View)Mockito.mock(ComponentColumn.View.class), AbstractLayoutEditorTest.this.dnDManager, AbstractLayoutEditorTest.this.helper, (Event)Mockito.mock(Event.class)){

                    protected boolean hasConfiguration() {
                        return false;
                    }
                };
                componentColumn.setId(this.idGenerator.createColumnID(this.getId()));
                return componentColumn;
            }

            protected ColumnWithComponents createColumnWithComponentsInstance() {
                ColumnWithComponents columnWithComponents = new ColumnWithComponents((ColumnWithComponents.View)Mockito.mock(ColumnWithComponents.View.class), null, AbstractLayoutEditorTest.this.dnDManager, AbstractLayoutEditorTest.this.helper, (Event)Mockito.mock(Event.class)){

                    protected Row createInstanceRow() {
                        return AbstractLayoutEditorTest.this.rowProducer();
                    }

                    protected void destroy(Object o) {
                    }
                };
                columnWithComponents.setId(this.idGenerator.createColumnID(this.getId()));
                return columnWithComponents;
            }

            protected void destroy(Object o) {
            }
        };
    }

    public LayoutTemplate getLayoutFromFileTemplate(String templateURL) throws Exception {
        URL resource = this.getClass().getClassLoader().getResource(templateURL);
        String layoutEditorModel = new String(Files.readAllBytes(Paths.get(resource.toURI())));
        LayoutTemplate layoutTemplate = (LayoutTemplate)this.gson.fromJson(layoutEditorModel, LayoutTemplate.class);
        return layoutTemplate;
    }

    public String convertLayoutToString(LayoutTemplate layoutTemplate) {
        String layoutContent = this.gson.toJson((Object)layoutTemplate);
        return layoutContent;
    }

    protected int getRowsSizeFromContainer() {
        return this.container.getRows().size();
    }

    protected List<Column> getColumns(Row row) {
        return row.getColumns();
    }

    protected Column getColumnByIndex(Row row, int index) {
        return (Column)row.getColumns().get(index);
    }

    protected Row getRowByIndex(int index) {
        return (Row)this.container.getRows().get(index);
    }

    @Before
    public void setup() {
        this.container = this.createContainer();
        this.container.setup();
    }

    protected LayoutTemplate loadLayout(String singleRowComponentLayout) throws Exception {
        LayoutTemplate layoutTemplate = this.getLayoutFromFileTemplate(singleRowComponentLayout);
        this.container.load(layoutTemplate, "title", "subtitle");
        return layoutTemplate;
    }

    protected List<Column> extractColumnsFrom(ColumnWithComponents columnWithComponents) {
        return columnWithComponents.getRow().getColumns();
    }
}

