/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.client;

import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.LayoutEditorPresenter;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;
import org.uberfire.ext.layout.editor.client.components.container.Container;
import org.uberfire.ext.layout.editor.client.generator.LayoutGenerator;
import org.uberfire.ext.layout.editor.client.test.TestLayoutEditorPresenter;
import org.uberfire.ext.layout.editor.client.widgets.LayoutDragComponentGroupPresenter;

@RunWith(value=MockitoJUnitRunner.class)
public class LayoutEditorPresenterTest {
    public static final String LAYOUT_NAME = "test layout";
    public static final String EMPTY_TITLE_TEXT = "Empty title text";
    public static final String EMPTY_SUB_TITLE_TEXT = "Empty SubTitle text";
    public static final String DRAGGABLE_GROUP_NAME = "Draggable group name";
    public static final String DRAGGABLE_COMPONENT_NAME = "Draggable component name";
    @Mock
    private Container container;
    @Mock
    private LayoutGenerator layoutGenerator;
    @Mock
    private LayoutEditorPresenter.View view;
    @Mock
    private LayoutDragComponentGroupPresenter.View dragComponentGroupView;
    private LayoutTemplate testTemplate = new LayoutTemplate("test layout");
    private LayoutDragComponentGroupPresenter dragComponentGroupPresenter;
    private TestLayoutEditorPresenter presenter;

    @Before
    public void initialize() {
        ManagedInstance instance = (ManagedInstance)Mockito.mock(ManagedInstance.class);
        this.dragComponentGroupPresenter = (LayoutDragComponentGroupPresenter)Mockito.spy((Object)new LayoutDragComponentGroupPresenter(this.dragComponentGroupView));
        Mockito.when((Object)instance.get()).thenReturn((Object)this.dragComponentGroupPresenter);
        this.presenter = new TestLayoutEditorPresenter(this.view, this.container, this.layoutGenerator, (ManagedInstance<LayoutDragComponentGroupPresenter>)instance);
    }

    @Test
    public void testInitialization() {
        ((LayoutEditorPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        this.presenter.initNew();
        ((Container)Mockito.verify((Object)this.container)).getView();
        ((LayoutEditorPresenter.View)Mockito.verify((Object)this.view)).setupDesign((UberElement)Matchers.any());
    }

    @Test
    public void testLoadLayout() {
        this.presenter.loadLayout(this.testTemplate, EMPTY_TITLE_TEXT, EMPTY_SUB_TITLE_TEXT);
        ((Container)Mockito.verify((Object)this.container)).load(this.testTemplate, EMPTY_TITLE_TEXT, EMPTY_SUB_TITLE_TEXT);
    }

    @Test
    public void testLoadEmptyLayout() {
        this.presenter.loadEmptyLayout(LAYOUT_NAME, EMPTY_TITLE_TEXT, EMPTY_SUB_TITLE_TEXT);
        ((Container)Mockito.verify((Object)this.container)).loadEmptyLayout(LAYOUT_NAME, LayoutTemplate.Style.FLUID, EMPTY_TITLE_TEXT, EMPTY_SUB_TITLE_TEXT);
    }

    @Test
    public void testAddDraggableGroups() {
        LayoutDragComponentGroup dragGroup = new LayoutDragComponentGroup(DRAGGABLE_GROUP_NAME, true);
        this.presenter.addDraggableGroup(dragGroup);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).init(dragGroup);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).getView();
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setExpanded(true);
        ((LayoutEditorPresenter.View)Mockito.verify((Object)this.view)).addDraggableComponentGroup((UberElement)Matchers.any());
        Assert.assertEquals((long)1L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNotNull((Object)this.presenter.getLayoutDragComponentGroups().get(DRAGGABLE_GROUP_NAME));
        LayoutDragComponent dragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.presenter.addDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME, dragComponent);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).addComponent(DRAGGABLE_COMPONENT_NAME, dragComponent);
        this.presenter.removeDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter)).removeComponent(DRAGGABLE_COMPONENT_NAME);
    }

    @Test
    public void testAddAndRemoveDraggableGroups() {
        this.testAddDraggableGroups();
        this.presenter.removeDraggableGroup(DRAGGABLE_GROUP_NAME);
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)2))).getView();
        ((LayoutEditorPresenter.View)Mockito.verify((Object)this.view)).removeDraggableComponentGroup((UberElement)Matchers.any());
        Assert.assertEquals((long)0L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNull((Object)this.presenter.getLayoutDragComponentGroups().get(DRAGGABLE_GROUP_NAME));
    }

    @Test
    public void testLayoutEditorClear() {
        this.testAddDraggableGroups();
        this.presenter.clear();
        ((Container)Mockito.verify((Object)this.container)).reset();
        ((LayoutDragComponentGroupPresenter)Mockito.verify((Object)this.dragComponentGroupPresenter, (VerificationMode)Mockito.times((int)2))).getView();
        ((LayoutEditorPresenter.View)Mockito.verify((Object)this.view)).removeDraggableComponentGroup((UberElement)Matchers.any());
        Assert.assertEquals((long)0L, (long)this.presenter.getLayoutDragComponentGroups().size());
        Assert.assertNull((Object)this.presenter.getLayoutDragComponentGroups().get(DRAGGABLE_GROUP_NAME));
    }

    @Test
    public void testHasDraggableGroup() {
        boolean result = this.presenter.hasDraggableGroup(DRAGGABLE_GROUP_NAME);
        Assert.assertFalse((boolean)result);
        this.testAddDraggableGroups();
        result = this.presenter.hasDraggableGroup(DRAGGABLE_GROUP_NAME);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testHasDraggableComponent() {
        boolean result = this.presenter.hasDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        Assert.assertFalse((boolean)result);
        LayoutDragComponentGroup dragGroup = new LayoutDragComponentGroup(DRAGGABLE_GROUP_NAME);
        this.presenter.addDraggableGroup(dragGroup);
        result = this.presenter.hasDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        Assert.assertFalse((boolean)result);
        LayoutDragComponent dragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.presenter.addDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME, dragComponent);
        Mockito.when((Object)this.dragComponentGroupPresenter.hasComponent(DRAGGABLE_COMPONENT_NAME)).thenReturn((Object)true);
        result = this.presenter.hasDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testRemoveComponent() {
        LayoutDragComponentGroup dragGroup = new LayoutDragComponentGroup(DRAGGABLE_GROUP_NAME);
        LayoutDragComponent dragComponent = (LayoutDragComponent)Mockito.mock(LayoutDragComponent.class);
        this.presenter.addDraggableGroup(dragGroup);
        this.presenter.addDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME, dragComponent);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView, (VerificationMode)Mockito.never())).setComponentVisible(Mockito.anyString(), Mockito.anyBoolean());
        Mockito.reset((Object[])new LayoutDragComponentGroupPresenter.View[]{this.dragComponentGroupView});
        Mockito.when((Object)this.dragComponentGroupView.hasComponent(DRAGGABLE_COMPONENT_NAME)).thenReturn((Object)true);
        this.presenter.addDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME, dragComponent);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView, (VerificationMode)Mockito.never())).addComponent(Mockito.anyString(), (LayoutDragComponent)Matchers.any());
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setComponentVisible(DRAGGABLE_COMPONENT_NAME, true);
        this.presenter.removeDraggableComponent(DRAGGABLE_GROUP_NAME, DRAGGABLE_COMPONENT_NAME);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView)).setComponentVisible(DRAGGABLE_COMPONENT_NAME, false);
        ((LayoutDragComponentGroupPresenter.View)Mockito.verify((Object)this.dragComponentGroupView, (VerificationMode)Mockito.never())).removeComponent(DRAGGABLE_COMPONENT_NAME);
    }
}

